/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.x.XDataSource;
import kd.bos.ksql.CONSTANT;
import kd.bos.ksql.shell.KDDriverUtil;
import kd.bos.trace.instrument.jdbc.DataSourceAOP;
import kd.bos.xdb.util.DateUtil;

public class DataSourceInfo
implements AutoCloseable {
    private DataSource dataSource;
    private XDataSource xdataSource;
    private String routeKey;
    private DBConfig conf;
    private String createTime;
    private AtomicInteger sharingCount = new AtomicInteger(1);

    static void setupDataSource(String routeKeys, DBType dbType, String ip, int port, String db, String user, String pwd, Properties dataSourceProperties) {
        DataSourceInfo.setupDataSource(null, null, routeKeys, dbType, ip, port, db, user, pwd, dataSourceProperties, 1, false);
    }

    static void setupDataSource(String routeKeys, DBType dbType, String ip, int port, String db, String user, String pwd, Properties dataSourceProperties, int loadFactor, boolean readOnly) {
        DataSourceInfo.setupDataSource(null, null, routeKeys, dbType, ip, port, db, user, pwd, dataSourceProperties, loadFactor, readOnly);
    }

    static void setupDataSource(String tenantId, String accountId, String routeKeys, DBType dbType, String ip, int port, String db, String user, String pwd, Properties dataSourceProperties, int loadFactor, boolean readOnly) {
        DataSourceInfo.setupDataSource(tenantId, accountId, routeKeys, dbType, ip, port, db, null, user, pwd, dataSourceProperties, loadFactor, readOnly);
    }

    static void setupDataSource(String tenantId, String accountId, String routeKeys, DBType dbType, String ip, int port, String db, String schema, String user, String pwd, Properties dataSourceProperties, int loadFactor, boolean readOnly) {
        String[] ss = routeKeys.toLowerCase().split(",");
        ArrayList<DBConfig> list = new ArrayList<DBConfig>(ss.length);
        for (String routeKey : ss) {
            DBConfig dbConfig = DBConfig.of(tenantId, accountId, routeKey.trim(), dbType, ip, port, db, schema, user, pwd, dataSourceProperties, loadFactor, readOnly);
            list.add(dbConfig);
        }
        DBConfig.__replaceDataCenter(list);
    }

    DataSourceInfo(final XDataSource dataSource, DBConfig conf) {
        this.xdataSource = dataSource;
        this.dataSource = new DataSourceAOP(dataSource){

            public String toString() {
                return super.toString() + "-" + dataSource.getPoolStatus();
            }
        };
        this.conf = conf;
        this.routeKey = conf.getRouteKey();
        this.createTime = DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    XDataSource getXDataSource() {
        return this.xdataSource;
    }

    boolean askForSharing(DBConfig conf) {
        return this.conf.canSharing(conf);
    }

    void increaseSharingCount() {
        this.sharingCount.incrementAndGet();
    }

    String getRouteKey() {
        return this.routeKey;
    }

    public DBConfig getDBConfig() {
        return this.conf;
    }

    public Connection getNewConnection() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", this.xdataSource.getUsername());
        properties.setProperty("password", this.xdataSource.getPassword());
        return KDDriverUtil.connect((String)this.xdataSource.getUrl(), (Properties)properties);
    }

    protected void setDBConfig(DBConfig conf) {
        this.conf = conf;
        if (CONSTANT.CONNECTION_SHARD) {
            this.routeKey = conf.getRouteKey();
        }
    }

    boolean noSharing() {
        return this.sharingCount.get() <= 0;
    }

    public AtomicInteger getSharingCount() {
        return this.sharingCount;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    @Override
    public void close() throws Exception {
        this.sharingCount.decrementAndGet();
    }

    public String toString() {
        return "dataSource=" + this.dataSource + ", sharingCount=" + this.sharingCount.get() + ", readOnly=" + this.conf.isReadOnly() + ", loadFactor=" + this.conf.getLoadFactor() + ", jdbcUrl=" + this.conf.getUrl() + ", createTime=" + this.createTime;
    }
}

