/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import com.alibaba.druid.filter.stat.StatFilterContext;
import com.alibaba.druid.filter.stat.StatFilterContextListener;
import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.DataSourceType;
import kd.bos.db.datasource.x.XDataSource;
import kd.bos.db.datasource.x.XDataSourceFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.trace.instrument.druid.DruidStatFilterContextListener;

class DataSourceInfoCreator {
    private static final Map<String, String> dbcp_keymap = new HashMap<String, String>();
    private static final Map<String, String> druid_keymap = new HashMap<String, String>();
    private static final Map<String, String> hikari_keymap = new HashMap<String, String>();

    DataSourceInfoCreator() {
    }

    private static void transProperties(Properties defaultProps, DataSourceType type) {
        if (defaultProps == null || defaultProps.isEmpty()) {
            return;
        }
        Map<String, String> keyMap = null;
        switch (type) {
            case dbcp: {
                keyMap = dbcp_keymap;
                break;
            }
            case druid: {
                keyMap = druid_keymap;
                break;
            }
            case hikari: {
                keyMap = hikari_keymap;
                break;
            }
            default: {
                return;
            }
        }
        for (String oldKey : new HashSet<String>(keyMap.keySet())) {
            String newKey = keyMap.get(oldKey);
            if (newKey.equals(oldKey)) continue;
            if (newKey.length() == 0) {
                defaultProps.remove(oldKey);
                continue;
            }
            String value = defaultProps.getProperty(oldKey);
            if (value == null) continue;
            if (!defaultProps.containsKey(newKey)) {
                defaultProps.put(newKey, value);
            }
            defaultProps.remove(oldKey);
        }
    }

    /*
     * Exception decompiling
     */
    static DataSourceInfo createDataSource(DBConfig dbInfo, Properties defaultProps, DataSourceType type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 19[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static DataSourceInfo createHikariDataSource(DBConfig dbInfo, Properties defaultProps) {
        try {
            Properties props = new Properties();
            if (defaultProps != null) {
                props.putAll((Map<?, ?>)defaultProps);
            }
            props.putAll((Map<?, ?>)dbInfo.getDefaultProperties());
            final XDataSource ds = XDataSourceFactory.hikariDataSource(dbInfo.getSharingId(), dbInfo, props);
            ds.setDBConfig(dbInfo);
            return new DataSourceInfo(ds, dbInfo){

                @Override
                public void close() throws Exception {
                    super.close();
                    if (this.noSharing()) {
                        ds.close();
                    }
                }
            };
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.dataSource, new Object[]{e.getMessage() + "\nurl=" + dbInfo.getUrl()});
        }
    }

    private static DataSourceInfo createDBCPDataSource(DBConfig dbInfo, Properties defaultProps) {
        try {
            Properties props = new Properties();
            props.setProperty("initialSize", String.valueOf(dbInfo.getPoolInitialSize()));
            props.setProperty("minIdle", String.valueOf(dbInfo.getPoolMinIdle()));
            props.setProperty("maxIdle", String.valueOf(dbInfo.getPoolMaxIdle()));
            props.setProperty("maxTotal", String.valueOf(dbInfo.getPoolMaxActive()));
            props.setProperty("maxWaitMillis", String.valueOf(dbInfo.getPoolMaxWait()));
            props.setProperty("removeAbandonedOnBorrow", Boolean.FALSE.toString());
            props.setProperty("removeAbandonedOnMaintenance", Boolean.FALSE.toString());
            if (defaultProps != null) {
                props.putAll((Map<?, ?>)defaultProps);
            }
            props.putAll((Map<?, ?>)dbInfo.getDefaultProperties());
            DataSourceInfoCreator.putConstants(dbInfo, props);
            props.setProperty("rollbackOnReturn", "false");
            props.setProperty("enableAutocommitOnReturn", "true");
            final XDataSource ds = XDataSourceFactory.dbcpDataSource(dbInfo.getSharingId(), props);
            ds.setDBConfig(dbInfo);
            return new DataSourceInfo(ds, dbInfo){

                @Override
                public void close() throws Exception {
                    super.close();
                    if (this.noSharing()) {
                        ds.close();
                    }
                }
            };
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.dataSource, new Object[]{e.getMessage()});
        }
    }

    private static DataSourceInfo createDruidDataSource(DBConfig dbInfo, Properties defaultProps) {
        try {
            Properties props = new Properties();
            props.setProperty("initialSize", String.valueOf(dbInfo.getPoolInitialSize()));
            props.setProperty("minIdle", String.valueOf(dbInfo.getPoolMinIdle()));
            props.setProperty("maxIdle", String.valueOf(dbInfo.getPoolMaxIdle()));
            props.setProperty("maxActive", String.valueOf(dbInfo.getPoolMaxActive()));
            props.setProperty("maxWait", String.valueOf(dbInfo.getPoolMaxWait()));
            if (defaultProps != null) {
                props.putAll((Map<?, ?>)defaultProps);
            }
            props.putAll((Map<?, ?>)dbInfo.getDefaultProperties());
            DataSourceInfoCreator.putConstants(dbInfo, props);
            final XDataSource ds = XDataSourceFactory.druidDataSource(dbInfo.getSharingId(), props);
            ds.setDBConfig(dbInfo);
            ((DruidDataSource)ds.getDataSource()).addFilters("stat");
            StatFilterContext.getInstance().addContextListener((StatFilterContextListener)new DruidStatFilterContextListener());
            return new DataSourceInfo(ds, dbInfo){

                @Override
                public void close() throws Exception {
                    super.close();
                    if (this.noSharing()) {
                        ds.close();
                    }
                }
            };
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.dataSource, new Object[]{e.getMessage()});
        }
    }

    private static void putConstants(DBConfig dbInfo, Properties props) {
        if (props.getProperty("driverClassName") == null) {
            props.setProperty("driverClassName", dbInfo.getDriver());
        }
        props.setProperty("url", dbInfo.getUrl());
        props.setProperty("username", dbInfo.getUser());
        props.setProperty("password", dbInfo.getPassword());
        props.setProperty("defaultAutoCommit", "true");
        String validationQuery = "SELECT 1";
        if (dbInfo.getDBType() == DBType.Oracle || dbInfo.getDBType() == DBType.DM || dbInfo.getDBType() == DBType.YasDB) {
            validationQuery = validationQuery + " FROM DUAL";
        }
        props.setProperty("validationQuery", validationQuery);
        props.setProperty("testOnBorrow", "true");
        props.setProperty("testWhileIdle", "true");
        props.setProperty("timeBetweenEvictionRunsMillis", "600000");
        props.setProperty("timeBetweenConnectErrorMillis", "180000");
    }

    static {
        dbcp_keymap.put("initialSize", "initialSize");
        dbcp_keymap.put("maxTotal", "maxTotal");
        dbcp_keymap.put("maxIdle", "maxIdle");
        dbcp_keymap.put("minIdle", "minIdle");
        dbcp_keymap.put("maxWait", "maxWaitMillis");
        druid_keymap.put("initialSize", "initialSize");
        druid_keymap.put("maxTotal", "maxActive");
        druid_keymap.put("maxIdle", "maxIdle");
        druid_keymap.put("minIdle", "minIdle");
        druid_keymap.put("maxWait", "maxWait");
        hikari_keymap.put("initialSize", "");
        hikari_keymap.put("maxTotal", "maximumPoolSize");
        hikari_keymap.put("maxIdle", "");
        hikari_keymap.put("minIdle", "minimumIdle");
        hikari_keymap.put("maxWait", "connectionTimeout");
    }
}

