/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.bundle.Resources;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceChangedLogger;
import kd.bos.db.datasource.DataSourceConfig;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.ReplicationDelayInfo;
import kd.bos.db.datasource.ReplicationDelayInfoChangeListener;
import kd.bos.db.datasource.ReplicationDelayInfoManager;
import kd.bos.db.datasource.ReplicationDelayInfoQueryFactory;
import kd.bos.db.datasource.SmoothWeightedBalancer;
import kd.bos.db.datasource.x.XDataSource;
import kd.bos.ksql.CONSTANT;

class DataSourceInfoGroup
implements AutoCloseable {
    private String key;
    private SmoothWeightedBalancer<DataSourceInfo> balancing;
    private DataSourceInfo rw;
    private final List<DataSourceInfoHolder> rList = new ArrayList<DataSourceInfoHolder>();
    private List<DBConfig> readOnlyDBConfigs = new ArrayList<DBConfig>();

    DataSourceInfoGroup(String key, DataSourceInfo ... dss) {
        this.key = key;
        for (DataSourceInfo ds : dss) {
            this.doAdd(ds);
        }
    }

    public void init() {
        if (this.rList.isEmpty()) {
            return;
        }
        for (DataSourceInfoHolder holder : this.rList) {
            if (!holder.ds.getDBConfig().isReadOnly()) {
                holder.delay = false;
                continue;
            }
            if (!DataSourceConfig.isEnableReplicationCheck()) {
                holder.delay = false;
                continue;
            }
            if (holder.replicationDelayInfoManager != null) continue;
            ReplicationDelayInfoManager replicationDelayInfoManager = ReplicationDelayInfoQueryFactory.get(this.rw, holder.ds);
            if (replicationDelayInfoManager != null) {
                ReplicationDelayInfoChangeListenerImpl listener = new ReplicationDelayInfoChangeListenerImpl(holder, this);
                replicationDelayInfoManager.registerReplicationDelayInfoListener(listener);
                holder.replicationDelayInfoManager = replicationDelayInfoManager;
                holder.updateDelayInfo(replicationDelayInfoManager.getReplicationDelayInfo());
                continue;
            }
            holder.delay = false;
        }
        this.buildBalancing();
    }

    private void buildBalancing() {
        ArrayList<DataSourceInfoHolder> availableReadonlyList = new ArrayList<DataSourceInfoHolder>(this.rList.size());
        ArrayList<DBConfig> availableReadonlyConfigList = new ArrayList<DBConfig>();
        for (DataSourceInfoHolder holder : this.rList) {
            if (holder.ds.getDBConfig().isReadOnly()) {
                if (holder.delay) continue;
                availableReadonlyConfigList.add(holder.ds.getDBConfig());
                availableReadonlyList.add(holder);
                continue;
            }
            if (holder.ds.getDBConfig().getLoadFactor() <= 0) continue;
            availableReadonlyList.add(holder);
        }
        this.balancing = this.buildBalancer(availableReadonlyList);
        this.readOnlyDBConfigs = ImmutableList.copyOf(availableReadonlyConfigList);
    }

    private SmoothWeightedBalancer<DataSourceInfo> buildBalancer(List<DataSourceInfoHolder> list) {
        ArrayList items = new ArrayList(list.size());
        for (DataSourceInfoHolder holder : list) {
            SmoothWeightedBalancer.Item<DataSourceInfo> item = new SmoothWeightedBalancer.Item<DataSourceInfo>(holder.ds.getDBConfig().getLoadFactor(), holder.ds);
            items.add(item);
        }
        return new SmoothWeightedBalancer<DataSourceInfo>(items);
    }

    private void doAdd(DataSourceInfo ds) {
        if (!ds.getDBConfig().isReadOnly()) {
            if (this.rw != null) {
                if (CONSTANT.CONNECTION_SHARD) {
                    if (ds == this.rw) {
                        return;
                    }
                    if (ds.getDBConfig().getLoadFactor() > 0) {
                        this.rList.add(new DataSourceInfoHolder(ds, false));
                    }
                }
                String msg = this.key + Resources.get((String)"bos-dbengine", (String)"DataSourceInfoGroup_0", (String)"\u4e0d\u5141\u8bb8\u6709\u4e24\u4e2a\u6216\u4ee5\u4e0a\u7684\u5199\u5e93: \u65b0\u52a0\u5165=%1$s#%2$s#%3$s#%4$s, \u5df2\u5b58\u5728=%5$s#%6$s#%7$s#%8$s", (Object[])new Object[]{ds.getRouteKey(), ds.getDBConfig().getId(), ds.getDBConfig().getSharingId(), ds, this.rw.getRouteKey(), this.rw.getDBConfig().getId(), this.rw.getDBConfig().getSharingId(), this.rw});
                RuntimeException e = new RuntimeException(msg);
                throw e;
            }
            this.rw = ds;
            if (ds.getDBConfig().getLoadFactor() > 0) {
                this.rList.add(new DataSourceInfoHolder(ds, false));
            }
        } else if (ds.getDBConfig().getLoadFactor() > 0) {
            DataSourceInfoHolder slaveHolder = new DataSourceInfoHolder(ds, true);
            this.rList.add(slaveHolder);
        }
    }

    void add(DataSourceInfo ds) {
        this.doAdd(ds);
        this.init();
    }

    DataSourceInfo serve(boolean readOnly) {
        if (!readOnly || this.rList.isEmpty()) {
            if (this.rw == null) {
                String msg = Resources.get((String)"bos-dbengine", (String)"DataSourceInfoGroup_2", (String)"\u6570\u636e\u4e2d\u5fc3\u672a\u914d\u7f6e\u5199\u5e93: ", (Object[])new Object[0]) + this.key;
                throw new RuntimeException(msg);
            }
            return this.rw;
        }
        DataSourceInfo result = this.balancing.select();
        if (result == null) {
            result = this.rw;
        }
        return result;
    }

    boolean isReadOnlyDBAvailable() {
        return !this.readOnlyDBConfigs.isEmpty();
    }

    List<DBConfig> getReadOnlyDBConfigs() {
        return this.readOnlyDBConfigs;
    }

    boolean hasWriteDataSource() {
        return this.rw != null;
    }

    DataSourceInfo findForSharing(DBConfig conf) {
        if (!conf.isReadOnly()) {
            if (this.rw != null && this.rw.askForSharing(conf)) {
                return this.rw;
            }
        } else {
            for (DataSourceInfoHolder holder : this.rList) {
                if (!holder.ds.askForSharing(conf)) continue;
                return holder.ds;
            }
        }
        return null;
    }

    DataSourceInfo findSharedDataSource(DBConfig config) {
        if (!config.isReadOnly()) {
            DBConfig dbConfig = this.rw.getDBConfig();
            if (this.rw != null && dbConfig.canSharingDB(config)) {
                return this.rw;
            }
        } else {
            for (DataSourceInfoHolder holder : this.rList) {
                DBConfig dbConfig = holder.ds.getDBConfig();
                if (!dbConfig.canSharingDB(config)) continue;
                return holder.ds;
            }
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        if (this.rw != null) {
            this.rw.close();
        }
        for (DataSourceInfoHolder r : this.rList) {
            if (r.ds == this.rw) continue;
            r.ds.close();
        }
    }

    Set<XDataSource> getXDataSourceSet() {
        HashSet<XDataSource> set = new HashSet<XDataSource>();
        if (this.rw != null) {
            set.add(this.rw.getXDataSource());
        }
        if (this.rList.size() > 0) {
            for (DataSourceInfoHolder holder : this.rList) {
                set.add(holder.ds.getXDataSource());
            }
        }
        return set;
    }

    DataSourceInfo getRw() {
        return this.rw;
    }

    List<DataSourceInfo> getReadList() {
        if (this.rList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DataSourceInfo> readonlyList = new ArrayList<DataSourceInfo>(this.rList.size());
        for (DataSourceInfoHolder holder : this.rList) {
            readonlyList.add(holder.ds);
        }
        return Collections.unmodifiableList(readonlyList);
    }

    ImmutableList<DataSourceInfoHolder> getReadonlyHolderList() {
        if (this.rList.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<DataSourceInfoHolder> ret = new ArrayList<DataSourceInfoHolder>(this.rList.size());
        for (DataSourceInfoHolder holder : this.rList) {
            if (!holder.ds.getDBConfig().isReadOnly()) continue;
            ret.add(holder);
        }
        return ImmutableList.copyOf(ret);
    }

    void changePWD(DBConfig config) {
        boolean readOnly = config.isReadOnly();
        String pwd = config.getPassword();
        HashSet<DataSourceInfo> set = new HashSet<DataSourceInfo>(this.rList.size() + 1);
        set.add(this.rw);
        set.addAll(this.getReadList());
        for (DataSourceInfo ds : set) {
            DBConfig dbConfig = ds.getDBConfig();
            if ((!readOnly || !dbConfig.isReadOnly()) && (readOnly || dbConfig.isReadOnly()) || !dbConfig.canSharing(config) || dbConfig.getPassword().equals(pwd)) continue;
            ds.getXDataSource().setPassword(pwd);
            dbConfig.setPassword(pwd);
            DataSourceChangedLogger.log("change pwd: " + dbConfig.getSharingId());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("balancing(" + this.balancing + ")");
        sb.append(", rw(" + this.rw + ")");
        if (this.rList.size() == 1 && this.rList.get(0).ds == this.rw) {
            sb.append(", r=rw");
        } else {
            sb.append(", r=([" + this.rList + "])");
            int n = this.rList.size();
            for (int i = 0; i < n; ++i) {
                DataSourceInfo dsi;
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((dsi = this.rList.get(i).ds) == this.rw ? "rw" : dsi);
            }
        }
        return sb.toString();
    }

    static class ReplicationDelayInfoChangeListenerImpl
    implements ReplicationDelayInfoChangeListener {
        private final DataSourceInfoHolder holder;
        private final DataSourceInfoGroup dataSourceInfoGroup;

        public ReplicationDelayInfoChangeListenerImpl(DataSourceInfoHolder holder, DataSourceInfoGroup dataSourceInfoGroup) {
            this.holder = holder;
            this.dataSourceInfoGroup = dataSourceInfoGroup;
        }

        @Override
        public void onChange(ReplicationDelayInfo delayInfo) {
            boolean updated = this.holder.updateDelayInfo(delayInfo);
            if (updated) {
                this.dataSourceInfoGroup.buildBalancing();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicationDelayInfoChangeListenerImpl listener = (ReplicationDelayInfoChangeListenerImpl)o;
            return Objects.equals(this.holder, listener.holder) && Objects.equals(this.dataSourceInfoGroup, listener.dataSourceInfoGroup);
        }

        public int hashCode() {
            return Objects.hash(this.holder, this.dataSourceInfoGroup);
        }
    }

    static class DataSourceInfoHolder {
        private final DataSourceInfo ds;
        private volatile boolean delay;
        private volatile ReplicationDelayInfo delayInfo;
        private ReplicationDelayInfoManager replicationDelayInfoManager;

        public DataSourceInfoHolder(DataSourceInfo ds, boolean delay) {
            this.ds = ds;
            this.delay = delay;
        }

        public boolean updateDelayInfo(ReplicationDelayInfo delayInfo) {
            boolean oldDelay = this.delay;
            this.delay = delayInfo == null || delayInfo.getValue() == null ? true : this.replicationDelayInfoManager.checkDelayInfo(delayInfo);
            this.delayInfo = delayInfo;
            return this.delay != oldDelay;
        }

        public ReplicationDelayInfo getDelayInfo() {
            return this.delayInfo;
        }

        public DataSourceInfo getDs() {
            return this.ds;
        }

        public boolean isDelay() {
            return this.delay;
        }
    }
}

