/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import com.alibaba.druid.support.json.JSONUtils;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import kd.bos.db.QueryResource;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.datasource.DataSourceMXBean;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.util.DateUtil;

public class DataSourceMXBeanImpl
implements DataSourceMXBean {
    private static Log logger = LogFactory.getLog(DataSourceMXBeanImpl.class);
    private static final String LINE_BREAK = "<br/>";
    private static final Supplier<SimpleDateFormat> sdf = () -> DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private static final String objName = "kd.bos.db.datasource:name=DataSourceMXBean";
    private static final DataSourceMXBeanImpl mb = new DataSourceMXBeanImpl();
    private static final Map<DelegateConnection, ConnectionThreadStackInfo> actionConnectThreadStackMap = new ConcurrentHashMap<DelegateConnection, ConnectionThreadStackInfo>();
    private AtomicInteger connection_active_count = new AtomicInteger();
    private AtomicLong connection_created_count = new AtomicLong();

    public static void statConnectionOnCreate(DelegateConnection con) {
        DataSourceMXBeanImpl.mb.connection_active_count.incrementAndGet();
        DataSourceMXBeanImpl.mb.connection_created_count.incrementAndGet();
        actionConnectThreadStackMap.put(con, new ConnectionThreadStackInfo(con));
        new QueryResource(con, "mxbean count", () -> {
            actionConnectThreadStackMap.remove(con);
            DataSourceMXBeanImpl.mb.connection_active_count.decrementAndGet();
        });
    }

    public static DataSourceMXBean get() {
        return mb;
    }

    private DataSourceMXBeanImpl() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(objName));
        }
        catch (Exception e) {
            logger.warn("register datasource MXBean error", (Throwable)e);
        }
    }

    @Override
    public Date now() {
        return new Date();
    }

    @Override
    public Map<String, String> getDataSourceConfig() {
        Properties ps = DataSourceFactory.getDataSourceManager().getDataSourceConfig();
        if (ps != null) {
            HashMap<String, String> map = new HashMap<String, String>(ps.size());
            for (Object key : ps.keySet()) {
                map.put((String)key, ps.getProperty((String)key));
            }
            return map;
        }
        return new HashMap<String, String>();
    }

    @Override
    public int getActiveConnectionCount() {
        return this.connection_active_count.get();
    }

    @Override
    public long getCreatedConnectionCount() {
        return this.connection_created_count.get();
    }

    @Override
    public String getDataSourcePoolType() {
        return DataSourceFactory.getDataSourceManager().getDataSourceType().name();
    }

    @Override
    public int getAppCount() {
        return DataSourceFactory.getDataSourceManager().getAppCount();
    }

    @Override
    public Set<String> getAppIds() {
        return DataSourceFactory.getDataSourceManager().getAppIds();
    }

    @Override
    public int getDataSourcePoolCount() {
        return DataSourceFactory.getDataSourceManager().getDatasourceCount();
    }

    @Override
    public String getDataSourcePoolSummary() {
        return DataSourceFactory.getDataSourceManager().statTotalPoolStatus().toString();
    }

    @Override
    public Map<String, String> getDataSourceAppsMap() {
        return DataSourceFactory.getDataSourceManager().getDataSourceAppsMap();
    }

    @Override
    public Map<String, List<String>> getActiveConnectionThreadStack() {
        TreeMap<String, List<String>> stackMap = new TreeMap<String, List<String>>();
        for (DelegateConnection con : new HashSet<DelegateConnection>(actionConnectThreadStackMap.keySet())) {
            ConnectionThreadStackInfo si = actionConnectThreadStackMap.get(con);
            if (si == null) continue;
            String key = "#[" + sdf.get().format(si.createTime) + ']' + con.getDBConfig().getRouteKey() + '@' + con.getRouteKey() + '-' + con.id();
            stackMap.put(key, Arrays.asList(si.toString().split("\n")));
        }
        return stackMap;
    }

    @Override
    public List<Map<String, String>> getActiveConnectionThreadsInfo() {
        ArrayList<Map<String, String>> threadsLs = new ArrayList<Map<String, String>>(8);
        for (DelegateConnection con : new HashSet<DelegateConnection>(actionConnectThreadStackMap.keySet())) {
            ConnectionThreadStackInfo si = actionConnectThreadStackMap.get(con);
            if (si == null) continue;
            HashMap<String, String> threadInfo = new HashMap<String, String>(4);
            threadInfo.put("conCreateTime", String.valueOf(si.createTime));
            threadInfo.put("conHoldTime", String.valueOf(System.currentTimeMillis() - si.createTime));
            threadInfo.put("dbConfig.routeKey", con.getDBConfig().getRouteKey());
            threadInfo.put("con.routeKey", con.getRouteKey());
            threadInfo.put("con.url", con.getDBConfig().getUrl());
            threadInfo.put("conActiveThread", si.thread);
            threadInfo.put("conActiveStack", si.stack);
            threadsLs.add(threadInfo);
        }
        return threadsLs;
    }

    @Override
    public Map<String, List<String>> getActiveConnectionTop10LongTerm() {
        List<ConnectionThreadStackInfo> stacks = new ArrayList<ConnectionThreadStackInfo>(actionConnectThreadStackMap.values());
        Collections.sort(stacks, new Comparator<ConnectionThreadStackInfo>(){

            @Override
            public int compare(ConnectionThreadStackInfo o1, ConnectionThreadStackInfo o2) {
                long t = o1.createTime - o2.createTime;
                return t == 0L ? 0 : (t > 0L ? 1 : -1);
            }
        });
        long ts = System.currentTimeMillis();
        stacks = stacks.subList(0, Math.min(10, stacks.size()));
        TreeMap<String, List<String>> ret = new TreeMap<String, List<String>>();
        int i = 1;
        for (ConnectionThreadStackInfo stack : stacks) {
            String key = "#" + i + ".(" + (ts - stack.createTime) + "ms)" + stack.con.getDBConfig().getRouteKey() + '@' + stack.con.getRouteKey() + '-' + stack.con.id();
            ++i;
            ret.put(key, Arrays.asList(stack.toString().split("\n")));
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(4096);
        String emptyPlace = "   ";
        sb.append("now=").append(this.now());
        sb.append("<br/>datasource.metric.connection.threadstack   " + this.isEnableConnectionThreadStack());
        sb.append("<br/>getDataSourceConfig");
        Map<String, String> dataSourceConfig = this.getDataSourceConfig();
        for (Map.Entry<String, String> entry : dataSourceConfig.entrySet()) {
            sb.append(LINE_BREAK).append(entry.getKey()).append('=').append(entry.getValue());
        }
        sb.append("<br/>getDataSourcePoolType   ").append(this.getDataSourcePoolType());
        sb.append("<br/>getRouteCount   ").append(this.getAppCount());
        sb.append("<br/>getRouteKeys");
        for (String string : this.getAppIds()) {
            sb.append(LINE_BREAK).append(emptyPlace).append(string);
        }
        sb.append("<br/>getDataSourcePoolCount   ").append(this.getDataSourcePoolCount());
        sb.append("<br/>getDataSourcePoolSummary   ").append(this.getDataSourcePoolSummary());
        sb.append("<br/>getDataSourceRouteKeysMap");
        Map<String, String> dataSourceAppsMap = this.getDataSourceAppsMap();
        for (Map.Entry<String, String> entry : dataSourceAppsMap.entrySet()) {
            sb.append(LINE_BREAK).append(emptyPlace).append(entry.getKey()).append(" : ").append(entry.getValue());
        }
        sb.append("<br/>getActiveConnectionCount   ").append(this.getActiveConnectionCount());
        sb.append("<br/>getCreatedConnectionCount   ").append(this.getCreatedConnectionCount());
        sb.append("<br/><font color='blue'>getActiveConnectionThreadStack");
        Map<String, List<String>> map = this.getActiveConnectionThreadStack();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            sb.append(LINE_BREAK).append(emptyPlace).append(entry.getKey());
            for (String stackLline : entry.getValue()) {
                sb.append(LINE_BREAK).append(emptyPlace).append(stackLline);
            }
        }
        sb.append("</font>");
        sb.append("<br/><font color='red'>getActiveConnectionTop10LongTerm");
        Map<String, List<String>> map2 = this.getActiveConnectionTop10LongTerm();
        for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
            sb.append(LINE_BREAK).append(emptyPlace).append(entry.getKey());
            for (String stackLline : entry.getValue()) {
                sb.append(LINE_BREAK).append(emptyPlace).append(stackLline);
            }
        }
        sb.append("</font>");
        return sb.toString();
    }

    @Override
    public TabularData getDataSourceTabularData() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("datasource.metric.connection.threadstack", String.valueOf(this.isEnableConnectionThreadStack()));
        Map<String, String> dataSourceConfig = this.getDataSourceConfig();
        StringBuilder dataSourceConfigSb = this.appendEach(dataSourceConfig, "=");
        map.put("getDataSourceConfig", dataSourceConfigSb.toString());
        map.put("getDataSourcePoolType", this.getDataSourcePoolType());
        map.put("getRouteCount", String.valueOf(this.getAppCount()));
        StringBuilder appIdSb = new StringBuilder();
        int n = 0;
        for (String appId : this.getAppIds()) {
            if (n > 0) {
                appIdSb.append('\n');
            }
            appIdSb.append(appId);
            ++n;
        }
        map.put("getRouteKeys", appIdSb.toString());
        map.put("getDataSourcePoolCount", String.valueOf(this.getDataSourcePoolCount()));
        map.put("getDataSourcePoolSummary", this.getDataSourcePoolSummary());
        Map<String, String> dataSourceAppsMap = this.getDataSourceAppsMap();
        StringBuilder dataSourceAppSb = this.appendEach(dataSourceAppsMap, " : ");
        map.put("getDataSourceRouteKeysMap", dataSourceAppSb.toString());
        map.put("getActiveConnectionCount", String.valueOf(this.getActiveConnectionCount()));
        map.put("getCreatedConnectionCount", String.valueOf(this.getCreatedConnectionCount()));
        StringBuilder activeConnectionThreadStackSb = new StringBuilder();
        Map<String, List<String>> activeConnectionThreadStack = this.getActiveConnectionThreadStack();
        for (Map.Entry<String, List<String>> entry : activeConnectionThreadStack.entrySet()) {
            activeConnectionThreadStackSb.append("\n").append(entry.getKey());
            for (String string : entry.getValue()) {
                activeConnectionThreadStackSb.append("\n\t").append(string);
            }
        }
        map.put("getActiveConnectionThreadStack", activeConnectionThreadStackSb.toString());
        StringBuilder activeConnectionTop10LongTermSb = new StringBuilder();
        Map<String, List<String>> activeConnectionTop10LongTerm = this.getActiveConnectionTop10LongTerm();
        for (Map.Entry entry : activeConnectionTop10LongTerm.entrySet()) {
            activeConnectionTop10LongTermSb.append("\n").append((String)entry.getKey());
            for (String stackLline : (List)entry.getValue()) {
                activeConnectionTop10LongTermSb.append("\n\t").append(stackLline);
            }
        }
        map.put("getActiveConnectionTop10LongTerm", activeConnectionTop10LongTermSb.toString());
        TabularData tabularData = null;
        try {
            tabularData = DataSourceMXBeanImpl.mapToTabularData(map);
        }
        catch (Exception exception) {
            logger.warn("mapToTabularData err: " + JSONUtils.toJSONString(map));
        }
        return tabularData;
    }

    private StringBuilder appendEach(Map<String, String> map, String delim) {
        StringBuilder ret = new StringBuilder();
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (n > 0) {
                ret.append('\n');
            }
            ret.append(entry.getKey()).append(delim).append(entry.getValue());
            ++n;
        }
        return ret;
    }

    private static TabularData mapToTabularData(Map<String, String> map) throws OpenDataException {
        CompositeType ct = new CompositeType("dataSource", "for dataSource", new String[]{"key", "value"}, new String[]{"key of map", "value of map"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
        TabularType tt = new TabularType("dataSource", "for dataSource", ct, new String[]{"key"});
        TabularDataSupport td = new TabularDataSupport(tt);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CompositeDataSupport cd = new CompositeDataSupport(ct, new String[]{"key", "value"}, new Object[]{entry.getKey(), entry.getValue()});
            td.put(cd);
        }
        return td;
    }

    @Override
    public boolean isEnableConnectionThreadStack() {
        return Boolean.getBoolean("datasource.metric.connection.threadstack");
    }

    @Override
    public void enableConnectionThreadStack() {
        System.setProperty("datasource.metric.connection.threadstack", String.valueOf(true));
    }

    @Override
    public void disenableConnectionThreadStack() {
        System.setProperty("datasource.metric.connection.threadstack", String.valueOf(false));
    }

    private static class ConnectionThreadStackInfo {
        private long createTime = System.currentTimeMillis();
        private DelegateConnection con;
        private String stack = null;
        private final String thread;

        private ConnectionThreadStackInfo(DelegateConnection con) {
            this.con = con;
            this.thread = Thread.currentThread().toString();
            if (mb.isEnableConnectionThreadStack()) {
                StackTraceElement[] ses = Thread.currentThread().getStackTrace();
                StringBuilder sb = new StringBuilder(512);
                for (int i = 5; i < ses.length; ++i) {
                    sb.append(ses[i]);
                    sb.append('\n');
                }
                this.stack = sb.toString();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("#" + this.con).append('\n');
            sb.append("#Thread=").append(this.thread);
            sb.append("#Ref=" + this.con.getRef()).append('\n');
            sb.append("#CreateTime=" + ((SimpleDateFormat)sdf.get()).format(new Date(this.createTime))).append('\n');
            sb.append("#HoldTime=" + (System.currentTimeMillis() - this.createTime) + "ms").append('\n');
            if (this.stack != null) {
                sb.append("#[STACK]").append('\n').append(this.stack);
            }
            return sb.toString();
        }
    }
}

