/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kd.bos.bundle.Resources;
import kd.bos.context.OperationContextCreator;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceCreateService;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.DataSourceInfoGroup;
import kd.bos.db.datasource.DataSourcePropertyManager;
import kd.bos.db.datasource.DataSourceType;
import kd.bos.db.datasource.x.XDataSource;
import kd.bos.db.datasource.x.XPoolStatus;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.bos.util.DisCardUtil;

class DataSourceManager {
    private static Log logger = LogFactory.getLog(DataSourceManager.class);
    private final DataSourcePropertyManager dataSourcePropertyManager = new DataSourcePropertyManager();

    DataSourceManager() {
        TenantListenerManager.addTenantListener(new TenantListener(){

            @Override
            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        DataSourceManager.this.createAccountGroup(tenantListenerInfo);
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    logger.error("TenantListener onTenantAccountsAdded failed: " + e);
                }
            }

            @Override
            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        DataSourceManager.this.destoryAccountGroup(tenantListenerInfo);
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    logger.error("TenantListener onTenantAccountsRemoved failed: " + e);
                }
            }
        });
    }

    Properties getDataSourceConfig() {
        return this.dataSourcePropertyManager.getDefaultProperty();
    }

    DataSourceType getDataSourceType() {
        return this.dataSourcePropertyManager.getDataSourceType();
    }

    String getSharedRouteKey(String tenantId, String routeKey, String accountId) {
        return this.getGroup(tenantId, routeKey, accountId).serve(false).getRouteKey();
    }

    void destoryGroup(String tenantId, String routeKey, String accountId) {
        try {
            Map<String, DataSourceInfoGroup> map = DataSourceCreateService.getAccountGroupMap(tenantId, accountId);
            DataSourceInfoGroup dsi = map.remove(routeKey);
            if (dsi != null) {
                dsi.close();
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }

    void registDataSourceIfNotExists(String tenantId, String accountId, String routeKey, DBType dbType, String ip, int port, String db, String user, String pwd, Properties dataSourceProperties) {
        if (routeKey == null || routeKey.trim().length() == 0) {
            throw new IllegalArgumentException(Resources.get((String)"bos-dbengine", (String)"DataSourceManager_0", (String)"routeKey\u4e0d\u80fd\u4e3a\u7a7a:", (Object[])new Object[0]) + routeKey);
        }
        DataSourceCreateService.getOrCreateGroup(tenantId, accountId, routeKey, this.dataSourcePropertyManager.getProperty(accountId, routeKey), this.dataSourcePropertyManager.getDataSourceType(), () -> {
            ArrayList<DBConfig> confs = new ArrayList<DBConfig>(1);
            confs.add(DBConfig.of(tenantId, accountId, routeKey, dbType, ip, port, db, user, pwd, dataSourceProperties, 1, false));
            return confs;
        });
    }

    DataSourceInfoGroup getGroup(String tenantId, String routeKey, String accountId) {
        return DataSourceCreateService.getOrCreateGroup(tenantId, accountId, routeKey, this.dataSourcePropertyManager.getProperty(accountId, routeKey), this.dataSourcePropertyManager.getDataSourceType(), null);
    }

    DataSourceInfo getSplittingReadDataSourceInfo(Set<DBConfig> dbConfigSet) {
        Collection<DBConfig> sortedConfs = dbConfigSet;
        if (dbConfigSet.size() > 1) {
            sortedConfs = new ArrayList<DBConfig>(dbConfigSet);
            Collections.sort((List)sortedConfs, new Comparator<DBConfig>(){

                @Override
                public int compare(DBConfig o1, DBConfig o2) {
                    if (o1.isReadOnly() != o2.isReadOnly()) {
                        if (o1.isReadOnly()) {
                            return -1;
                        }
                        return 1;
                    }
                    return o2.getLoadFactor() - o1.getLoadFactor();
                }
            });
        }
        for (DBConfig conf : sortedConfs) {
            Map<String, DataSourceInfoGroup> accountGroupMap = DataSourceCreateService.getAccountGroupMap(conf.getTenantId(), conf.getAccountId());
            for (DataSourceInfoGroup g : new ArrayList<DataSourceInfoGroup>(accountGroupMap.values())) {
                DataSourceInfo dsi = g.findForSharing(conf);
                if (dsi == null) continue;
                return dsi;
            }
        }
        OperationContextCreator.getOrCreateForBos();
        String msg = Resources.get((String)"bos-dbengine", (String)"DataSourceManager_1", (String)"\u6570\u636e\u6e90\u5df2\u7ecf\u53d8\u52a8\uff0c\u672a\u627e\u5230\u7b26\u5408\u7684\u6570\u636e\u6e90\uff1a", (Object[])new Object[0]) + dbConfigSet;
        throw new RuntimeException(msg);
    }

    String dumpStatus(boolean withDetail) {
        String lineBreak = "<br/>";
        StringBuilder sb = new StringBuilder(1024);
        sb.append(lineBreak).append("    defaultProps=").append(this.dataSourcePropertyManager.getDefaultProperty());
        sb.append(lineBreak).append("    [app-datasource]");
        XPoolStatus total = new XPoolStatus("TOTAL");
        HashSet<XDataSource> allDS = new HashSet<XDataSource>();
        Map<String, DataSourceInfoGroup> groupMap = DataSourceCreateService.toPlatGroupMap();
        int i = 0;
        for (Map.Entry<String, DataSourceInfoGroup> entry : groupMap.entrySet()) {
            String key = entry.getKey();
            DataSourceInfoGroup group = entry.getValue();
            sb.append(lineBreak).append("    ").append(++i).append(") ").append(key);
            sb.append(lineBreak).append("        ").append(group);
            DataSourceInfo rw = group.getRw();
            if (rw != null) {
                allDS.add(rw.getXDataSource());
                XPoolStatus xps = rw.getXDataSource().getPoolStatus();
                sb.append(lineBreak).append("        ").append(this.getShowDataSourceInfo(rw, true));
                total.addup(xps);
            }
            if (group.getReadList().size() > 0) {
                for (DataSourceInfo dsi : group.getReadList()) {
                    XDataSource ds = dsi.getXDataSource();
                    if (allDS.contains(ds)) continue;
                    allDS.add(ds);
                    XPoolStatus xps = rw.getXDataSource().getPoolStatus();
                    sb.append(lineBreak).append("        ").append(this.getShowDataSourceInfo(rw, true));
                    total.addup(xps);
                }
            }
            sb.append(lineBreak);
        }
        StringBuilder summary = new StringBuilder(withDetail ? sb.length() + 1024 : 1024);
        summary.append(lineBreak).append("    -------------------------------------------------------------------------------------------------------------------------");
        summary.append(lineBreak).append("    # routeKeys=").append(groupMap.size());
        summary.append(lineBreak).append("    # datasources=").append(allDS.size());
        summary.append(lineBreak).append("    # type=").append((Object)this.dataSourcePropertyManager.getDataSourceType());
        summary.append(lineBreak).append("    # ").append(total);
        summary.append(lineBreak).append("    -------------------------------------------------------------------------------------------------------------------------");
        if (withDetail) {
            summary.append((CharSequence)sb);
        }
        return summary.toString();
    }

    Map<String, Object> dumpStatusMap(boolean withDetail) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        HashMap<String, String> appDataSourceMap = new HashMap<String, String>(8);
        XPoolStatus total = new XPoolStatus("TOTAL");
        HashSet<XDataSource> allDS = new HashSet<XDataSource>(8);
        Map<String, DataSourceInfoGroup> groupMap = DataSourceCreateService.toPlatGroupMap();
        for (Map.Entry<String, DataSourceInfoGroup> entry : groupMap.entrySet()) {
            String key = entry.getKey();
            DataSourceInfoGroup group = entry.getValue();
            StringBuilder tmpSb = new StringBuilder(256);
            this.dealDataSourceInfoGroup2Monitor(tmpSb, group);
            for (XDataSource ds : group.getXDataSourceSet()) {
                if (allDS.contains(ds)) continue;
                allDS.add(ds);
                XPoolStatus xps = ds.getPoolStatus();
                total.addup(xps);
            }
            appDataSourceMap.put(key, tmpSb.toString());
        }
        map.put("apps", groupMap.size());
        map.put("datasources", allDS.size());
        map.put("type", (Object)this.dataSourcePropertyManager.getDataSourceType());
        map.put("totalPool", total);
        if (withDetail) {
            map.put("defaultProps", this.dataSourcePropertyManager.getDefaultProperty().toString());
            map.put("appDataSources", appDataSourceMap);
        }
        return map;
    }

    private void dealDataSourceInfoGroup2Monitor(StringBuilder tmpSb, DataSourceInfoGroup group) {
        DataSourceInfo rw = group.getRw();
        if (rw != null) {
            ArrayList<DataSourceInfoGroup.DataSourceInfoHolder> onlyReadList = new ArrayList<DataSourceInfoGroup.DataSourceInfoHolder>((Collection<DataSourceInfoGroup.DataSourceInfoHolder>)group.getReadonlyHolderList());
            if (!onlyReadList.isEmpty()) {
                tmpSb.append("[Master DataSource]\n");
                tmpSb.append(this.getShowDataSourceInfo(rw, false));
                tmpSb.append("[Slave DataSource]\n");
                int n = 1;
                for (DataSourceInfoGroup.DataSourceInfoHolder holder : onlyReadList) {
                    tmpSb.append("[Read ").append(n++).append("]\n");
                    int loadFactor = holder.getDs().getDBConfig().getLoadFactor();
                    tmpSb.append(this.getShowDataSourceInfo(holder.getDs(), false));
                    tmpSb.append("loadFactor=").append(loadFactor).append("\n");
                    tmpSb.append("delay=").append(holder.isDelay()).append('\n');
                    if (holder.getDelayInfo() == null) continue;
                    tmpSb.append("delayInfo=").append(holder.getDelayInfo()).append('\n');
                }
            } else {
                tmpSb.append(this.getShowDataSourceInfo(rw, false));
            }
        }
    }

    private String getShowDataSourceInfo(DataSourceInfo dataSourceInfo, boolean onlyPoolStatus) {
        StringBuilder ret = new StringBuilder(128);
        if (dataSourceInfo != null) {
            XPoolStatus poolStatus = dataSourceInfo.getXDataSource().getPoolStatus();
            ret.append("Pool:{");
            if (poolStatus.getActive() != null && poolStatus.getActive() >= 0) {
                ret.append("active:").append(poolStatus.getActive());
            }
            if (poolStatus.getIdle() != null && poolStatus.getIdle() >= 0) {
                ret.append(",idle:").append(poolStatus.getIdle());
            }
            if (poolStatus.getMaxTotal() != null && poolStatus.getMaxTotal() >= 0) {
                ret.append(",maxTotal:").append(poolStatus.getMaxTotal());
            }
            if (poolStatus.getMaxIdle() != null && poolStatus.getMaxIdle() >= 0) {
                ret.append(",maxIdle:").append(poolStatus.getMaxIdle());
            }
            if (poolStatus.getWaitCount() != null && poolStatus.getWaitCount() >= 0) {
                ret.append(",waitCount:").append(poolStatus.getWaitCount());
            }
            if (poolStatus.getCreatedCount() != null && poolStatus.getCreatedCount() >= 0L) {
                ret.append(",createdCount:").append(poolStatus.getCreatedCount());
            }
            if (poolStatus.getDestroyedCount() != null && poolStatus.getDestroyedCount() >= 0L) {
                ret.append(",destroyedCount:").append(poolStatus.getDestroyedCount());
            }
            if (poolStatus.getBorrowedCount() != null && poolStatus.getBorrowedCount() >= 0L) {
                ret.append(",borrowedCount:").append(poolStatus.getBorrowedCount());
            }
            if (poolStatus.getReturnedCount() != null && poolStatus.getReturnedCount() >= 0L) {
                ret.append(",returnedCount:").append(poolStatus.getReturnedCount());
            }
            ret.append(",createTime:").append(dataSourceInfo.getCreateTime());
            ret.append("}\n");
            if (!onlyPoolStatus) {
                ret.append("JdbcUrl:jdbcUrl=").append(dataSourceInfo.getDBConfig().getUrl()).append('\n');
                ret.append("SharingCount:").append(dataSourceInfo.getSharingCount().get()).append('\n');
            }
        }
        return ret.toString();
    }

    int getAppCount() {
        return DataSourceCreateService.toPlatGroupMap().size();
    }

    Set<String> getAppIds() {
        return new HashSet<String>(DataSourceCreateService.toPlatGroupMap().keySet());
    }

    int getDatasourceCount() {
        return new HashSet<DataSourceInfoGroup>(DataSourceCreateService.toPlatGroupMap().values()).size();
    }

    XPoolStatus statTotalPoolStatus() {
        XPoolStatus total = new XPoolStatus("TOTAL");
        HashSet<XDataSource> allDS = new HashSet<XDataSource>();
        for (DataSourceInfoGroup group : DataSourceCreateService.toPlatGroupMap().values()) {
            for (XDataSource ds : group.getXDataSourceSet()) {
                if (allDS.contains(ds)) continue;
                allDS.add(ds);
                XPoolStatus xps = ds.getPoolStatus();
                total.addup(xps);
            }
        }
        return total;
    }

    Map<String, String> getDataSourceAppsMap() {
        HashMap<String, TreeSet<String>> map = new HashMap<String, TreeSet<String>>();
        Map<String, DataSourceInfoGroup> groupMap = DataSourceCreateService.toPlatGroupMap();
        for (Map.Entry<String, DataSourceInfoGroup> entry : groupMap.entrySet()) {
            String routeKey = entry.getKey();
            DataSourceInfoGroup group = entry.getValue();
            for (XDataSource ds : group.getXDataSourceSet()) {
                String id = ds.getDBConfig().getSharingId();
                TreeSet<String> set = (TreeSet<String>)map.get(id);
                if (set == null) {
                    set = new TreeSet<String>();
                    map.put(id, set);
                }
                set.add(routeKey);
            }
        }
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            ret.put((String)entry.getKey(), String.valueOf(((Set)entry.getValue()).size()) + '=' + entry.getValue());
        }
        return ret;
    }

    private void createAccountGroup(TenantListenerInfo tenantListenerInfo) {
        List<Account> accountList = tenantListenerInfo.getAccountList();
        String tenantId = tenantListenerInfo.getTenantnumber();
        for (Account center : accountList) {
            String accountId = center.getAccountId();
            for (DBInstance dbInstance : center.getDBInstanceList()) {
                this.getGroup(tenantId, dbInstance.getRouteKey(), accountId);
            }
        }
    }

    private void destoryAccountGroup(TenantListenerInfo tenantListenerInfo) {
        List<Account> accountList = tenantListenerInfo.getAccountList();
        for (Account account : accountList) {
            for (DBInstance dbInstance : account.getDBInstanceList()) {
                this.destoryGroup(account.getTenantId(), dbInstance.getRouteKey(), account.getAccountId());
            }
        }
    }

    Map<String, Map<String, Object>> dumpDetailStatus() {
        HashMap<String, Map<String, Object>> deatailMap = new HashMap<String, Map<String, Object>>(4);
        HashSet<XDataSource> allDS = new HashSet<XDataSource>();
        Map<String, DataSourceInfoGroup> groupMap = DataSourceCreateService.toPlatGroupMap();
        for (Map.Entry<String, DataSourceInfoGroup> entry : groupMap.entrySet()) {
            String key = entry.getKey();
            DataSourceInfoGroup group = entry.getValue();
            for (XDataSource ds : group.getXDataSourceSet()) {
                if (allDS.contains(ds)) continue;
                allDS.add(ds);
                XPoolStatus xps = ds.getPoolStatus();
                HashMap<String, Integer> poolStatusMap = new HashMap<String, Integer>(4);
                poolStatusMap.put("pooMaxActive", ds.getDBConfig().getPoolMaxActive());
                poolStatusMap.put("activeCount", xps.getActive());
                poolStatusMap.put("waitCount", xps.getWaitCount());
                deatailMap.put(key, poolStatusMap);
            }
        }
        return deatailMap;
    }
}

