/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DataSourceInfo;

public class InitCustomDataSource {
    private static final List<LazyCaller> initCallers = new ArrayList<LazyCaller>();

    static void init() {
        for (LazyCaller caller : initCallers) {
            caller.call();
        }
    }

    public static void setupDataSource(String tenantId, String accountId, String routeKeys, DBType dbType, String ip, int port, String db, String user, String pwd, Properties dataSourceProperties, int loadFactor, boolean readOnly) {
        InitCustomDataSource.setupDataSource(tenantId, accountId, routeKeys, dbType, ip, port, db, null, user, pwd, dataSourceProperties, loadFactor, readOnly);
    }

    public static synchronized void setupDataSource(String tenantId, String accountId, String routeKeys, DBType dbType, String ip, int port, String db, String schema, String user, String pwd, Properties dataSourceProperties, int loadFactor, boolean readOnly) {
        initCallers.add(() -> DataSourceInfo.setupDataSource(tenantId, accountId, routeKeys, dbType, ip, port, db, schema, user, pwd, dataSourceProperties, loadFactor, readOnly));
    }

    private static interface LazyCaller {
        public void call();
    }
}

