/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceChangedLogger;
import kd.bos.db.datasource.DataSourceCreateService;
import kd.bos.db.datasource.DataSourceInfoGroup;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.tenant.TenantInfo;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.DisCardUtil;
import kd.bos.xdb.util.ConcurrentHashSet;
import kd.bos.xdb.util.Threads;

public final class PWDChangedWatcher {
    private static final AtomicBoolean started = new AtomicBoolean();
    private static final long start_delay = 10000L;
    private static final String MC_TENANT_ALLDATA_KEY = "mc.tenant.%s.data";
    private static Map<String, Account> accountMap = new ConcurrentHashMap<String, Account>();
    private static Set<String> watchingTenantNumberSet = new ConcurrentHashSet();
    private static Object snoop = new Object();

    public static void startWatch() {
        if (started.compareAndSet(false, true)) {
            Thread th = new Thread(Threads.wrapRunnable((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(10000L);
                        PWDChangedWatcher.initWatch();
                    }
                    catch (InterruptedException e) {
                        DisCardUtil.discard();
                    }
                }
            }));
            th.setDaemon(true);
            th.start();
        }
    }

    private static void initWatch() {
        accountMap.putAll(PWDChangedWatcher.getAccountMap());
        for (TenantInfo ti : AccountUtils.getAllTenantsByCurrentEnv()) {
            PWDChangedWatcher.doWatch(ti.getId());
        }
        TenantListenerManager.addTenantListener(new TenantListener(){

            @Override
            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                DisCardUtil.discard();
            }

            @Override
            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                DisCardUtil.discard();
            }

            @Override
            public void onTenantChanged(TenantListenerInfo tenantListenerInfo) {
                PWDChangedWatcher.doWatch(tenantListenerInfo.getTenantnumber());
            }
        });
        PWDChangedWatcher.round();
    }

    private static Map<String, Account> getAccountMap() {
        List<Account> allAccountsOfCurrentEnv = AccountUtils.getAllAccountsOfCurrentEnv();
        HashMap<String, Account> map = new HashMap<String, Account>(allAccountsOfCurrentEnv.size());
        for (Account account : allAccountsOfCurrentEnv) {
            map.put(account.getTenantId() + '#' + account.getAccountId(), account);
        }
        return map;
    }

    private static void doWatch(String tenantNumber) {
        if (watchingTenantNumberSet.add(tenantNumber)) {
            String tenantConfigKey = String.format(MC_TENANT_ALLDATA_KEY, tenantNumber);
            DataSourceChangedLogger.log("watch tenant config: " + tenantConfigKey);
            ConfigurationUtil.observeChange((String)tenantConfigKey, (ConfigurationChangeListener)new ConfigurationChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onChange(Object key, Object newValue) {
                    DataSourceChangedLogger.log("tenant config changed, key=" + key);
                    Object object = snoop;
                    synchronized (object) {
                        snoop.notifyAll();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void round() {
        while (!Thread.currentThread().isInterrupted()) {
            Object object = snoop;
            synchronized (object) {
                try {
                    snoop.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
                PWDChangedWatcher.checkChangePWD();
            }
        }
    }

    private static void checkChangePWD() {
        DataSourceChangedLogger.log("clear account cache");
        AccountUtils.clearAccountCache();
        Map<String, Account> newAccountMap = PWDChangedWatcher.getAccountMap();
        for (Map.Entry<String, Account> entry : newAccountMap.entrySet()) {
            String key = entry.getKey();
            Account oldAccount = accountMap.get(key);
            if (oldAccount == null) {
                MCDBUtil.removeDataSouce(entry.getValue().getAccountId());
                continue;
            }
            Map<String, DataSourceInfoGroup> accountGroupMap = null;
            Account newAccount = entry.getValue();
            Map<String, DBInstance> oldDBInstanceMap = PWDChangedWatcher.toDBInstanceMap(oldAccount.getDBInstanceList());
            Map<String, DBInstance> newDBInstanceMap = PWDChangedWatcher.toDBInstanceMap(newAccount.getDBInstanceList());
            boolean hasChanged = false;
            for (Map.Entry<String, DBInstance> e : oldDBInstanceMap.entrySet()) {
                DataSourceInfoGroup dig;
                DBInstance oldDB = e.getValue();
                DBInstance newDB = newDBInstanceMap.get(e.getKey());
                if (newDB == null || newDB.getDbpassword().equals(oldDB.getDbpassword())) continue;
                if (!hasChanged) {
                    hasChanged = true;
                }
                if (accountGroupMap == null) {
                    accountGroupMap = DataSourceCreateService.getAccountGroupMap(newAccount.getTenantId(), newAccount.getAccountId());
                }
                if ((dig = (DataSourceInfoGroup)accountGroupMap.get(newDB.getRouteKey().toLowerCase())) == null) continue;
                DBConfig config = DBConfig.fromDBInstance(newDB, newAccount.getTenantId(), newAccount.getAccountId());
                dig.changePWD(config);
            }
            if (!hasChanged) continue;
            MCDBUtil.removeDataSouce(newAccount.getAccountId());
        }
        accountMap = new ConcurrentHashMap<String, Account>(newAccountMap);
    }

    private static Map<String, DBInstance> toDBInstanceMap(List<DBInstance> dbInstanceList) {
        HashMap<String, DBInstance> map = new HashMap<String, DBInstance>(dbInstanceList.size());
        for (DBInstance db : dbInstanceList) {
            String key = (db.getDbip() + '#' + db.getDbport() + '#' + db.getDBInsatnce() + '#' + db.getDbuser()).toLowerCase();
            map.put(key, db);
        }
        return map;
    }
}

