/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.datasource.DataSourceConfig;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.ReplicationDelayInfo;
import kd.bos.db.datasource.ReplicationDelayInfoManagerBase;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class ReplicationDelayInfoManagerMySQLImpl
extends ReplicationDelayInfoManagerBase {
    private static final String serverVersionRegex = "(\\d+)\\.(\\d+)\\.(\\d+)";
    private static final Pattern serverVersionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    private static final String SQL_QUERY_VERSION = "/*dialect*/SELECT VERSION() AS v";
    private static final String SQL_SHOW_SLAVE = "/*dialect*/SHOW SLAVE STATUS";
    private static final String SQL_SHOW_REPLICATE = "/*dialect*/SHOW REPLICA STATUS";
    private static final Log log = LogFactory.getLog(ReplicationDelayInfoManagerMySQLImpl.class);
    private String sqlShowReplicationDelay = null;
    private String delayColumnName = null;

    public ReplicationDelayInfoManagerMySQLImpl(DataSourceInfo master, DataSourceInfo slave) {
        super(master, slave);
    }

    @Override
    public boolean checkDelayInfo(ReplicationDelayInfo delayInfo) {
        if (delayInfo == null || delayInfo.getValue() == null) {
            return true;
        }
        if (delayInfo.getUnit() == ReplicationDelayInfo.Unit.Seconds) {
            return delayInfo.getValue() > (long)DataSourceConfig.getMysqlMaxReplicationDelaySeconds();
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    ReplicationDelayInfo doUpdateDelayInfo() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setShowDelaySQLByServerVersion() throws Exception {
        if (this.sqlShowReplicationDelay != null) {
            return;
        }
        Version version = this.getServerVersion();
        this.sqlShowReplicationDelay = version.gte(8, 0, 22) ? SQL_SHOW_REPLICATE : SQL_SHOW_SLAVE;
    }

    private Long querySlaveDelaySecond(Connection connection) {
        try {
            return this.executeQuery(connection, this.sqlShowReplicationDelay, rs -> {
                if (this.delayColumnName == null) {
                    ResultSetMetaData metaData = rs.getMetaData();
                    ArrayList<String> columnNameList = new ArrayList<String>(metaData.getColumnCount());
                    for (int i = 0; i < metaData.getColumnCount(); ++i) {
                        columnNameList.add(metaData.getColumnName(i + 1));
                    }
                    this.delayColumnName = columnNameList.contains("Seconds_Behind_Master") ? "Seconds_Behind_Master" : "Seconds_Behind_Source";
                }
                ArrayList<Long> results = new ArrayList<Long>();
                while (rs.next()) {
                    Object delay = rs.getObject(this.delayColumnName);
                    if (delay instanceof Number) {
                        results.add(((Number)delay).longValue());
                        continue;
                    }
                    results.add(null);
                }
                if (results.size() > 1) {
                    return null;
                }
                if (results.isEmpty()) {
                    return null;
                }
                return (Long)results.get(0);
            });
        }
        catch (Throwable throwable) {
            log.warn("slave_db_delay: Cause an exception when query slave db replication delay info, " + throwable.getMessage(), throwable);
            return null;
        }
    }

    private Version getServerVersion() throws Exception {
        try (Connection connection = this.getSlave().getDataSource().getConnection();){
            Version version = this.executeQuery(connection, SQL_QUERY_VERSION, new ResultSetHandler<Version>(){

                @Override
                public Version handle(ResultSet rs) throws Exception {
                    String versionString = "";
                    if (rs.next()) {
                        versionString = rs.getString(1);
                        Matcher matcher = serverVersionPattern.matcher(versionString);
                        if (matcher.find()) {
                            int majorVersion = Integer.parseInt(matcher.group(1));
                            int minorVersion = Integer.parseInt(matcher.group(2));
                            int releaseVersion = Integer.parseInt(matcher.group(3));
                            return new Version(majorVersion, minorVersion, releaseVersion);
                        }
                    }
                    throw new RuntimeException("Can not match MySQL server version for: " + versionString);
                }
            });
            return version;
        }
    }

    private static class Version {
        final int major;
        final int minor;
        final int release;

        public Version(int major, int minor, int release) {
            this.major = major;
            this.minor = minor;
            this.release = release;
        }

        public boolean gte(int major, int minor, int release) {
            return this.major >= major && this.minor >= minor && this.release >= release;
        }
    }
}

