/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.ReplicationDelayInfoManager;
import kd.bos.db.datasource.ReplicationDelayInfoManagerMySQLImpl;
import kd.bos.db.datasource.ReplicationDelayInfoManagerPGImpl;
import kd.bos.db.datasource.ReplicationDelayInfoUpdateTask;
import kd.bos.util.Pair;

class ReplicationDelayInfoQueryFactory {
    private static final ConcurrentHashMap<String, ReplicationDelayInfoManager> cache = new ConcurrentHashMap();
    private static final List<Pair<DBType, Supplier>> supportedDBTypes = new ArrayList<Pair<DBType, Supplier>>();

    ReplicationDelayInfoQueryFactory() {
    }

    private static String getCacheKey(DataSourceInfo dataSourceInfo) {
        DBConfig config = dataSourceInfo.getDBConfig();
        return String.format("%s:%d", config.getIp(), config.getPort());
    }

    private static boolean checkDataSource(DataSourceInfo master, DataSourceInfo slave) {
        if (master.getDBConfig().getDBType() != slave.getDBConfig().getDBType()) {
            return false;
        }
        if (master.getDBConfig().isCluster() || slave.getDBConfig().isCluster()) {
            return false;
        }
        if (master == slave) {
            return false;
        }
        return !Objects.equals(master.getDBConfig().getIp(), slave.getDBConfig().getIp()) || master.getDBConfig().getPort() != slave.getDBConfig().getPort();
    }

    public static ReplicationDelayInfoManager get(DataSourceInfo master, DataSourceInfo slave) {
        Objects.requireNonNull(master, "Master datasource can not be null");
        Objects.requireNonNull(slave, "Slave datasource can not be null");
        if (!ReplicationDelayInfoQueryFactory.checkDataSource(master, slave)) {
            return null;
        }
        Supplier querySupplier = null;
        for (Pair<DBType, Supplier> item : supportedDBTypes) {
            if (item.getKey() != master.getDBConfig().getDBType()) continue;
            querySupplier = (Supplier)item.getValue();
            break;
        }
        if (querySupplier == null) {
            return null;
        }
        Supplier finalSupplier = querySupplier;
        return cache.computeIfAbsent(ReplicationDelayInfoQueryFactory.getCacheKey(slave), k -> {
            ReplicationDelayInfoManager query = finalSupplier.get(master, slave);
            ReplicationDelayInfoUpdateTask updateTask = new ReplicationDelayInfoUpdateTask(query);
            updateTask.start();
            return query;
        });
    }

    static {
        supportedDBTypes.add((Pair<DBType, Supplier>)new Pair((Object)DBType.MySQL, (Object)new Supplier(){

            @Override
            public ReplicationDelayInfoManager get(DataSourceInfo master, DataSourceInfo slave) {
                return new ReplicationDelayInfoManagerMySQLImpl(master, slave);
            }
        }));
        supportedDBTypes.add((Pair<DBType, Supplier>)new Pair((Object)DBType.PostgreSQL, (Object)new Supplier(){

            @Override
            public ReplicationDelayInfoManager get(DataSourceInfo master, DataSourceInfo slave) {
                return new ReplicationDelayInfoManagerPGImpl(master, slave);
            }
        }));
    }

    @FunctionalInterface
    private static interface Supplier {
        public ReplicationDelayInfoManager get(DataSourceInfo var1, DataSourceInfo var2);
    }
}

