/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.db.datasource.DataSourceConfig;
import kd.bos.thread.ThreadLifeCycleManager;

final class ReplicationDelayTaskScheduleService {
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, r -> {
        r = ThreadLifeCycleManager.wrapRunnable((Runnable)r);
        Thread thread = new Thread(r, "ReplicationDelayTaskScheduleService");
        thread.setDaemon(true);
        return thread;
    });

    ReplicationDelayTaskScheduleService() {
    }

    public static void schedule(Runnable task) {
        ReplicationDelayTaskScheduleService.schedule(task, DataSourceConfig.getReplicationDelayInfoUpdateTaskExecuteDelayMinute(), TimeUnit.MINUTES);
    }

    public static void schedule(Runnable task, int delay, TimeUnit timeUnit) {
        executorService.schedule(task, (long)delay, timeUnit);
    }
}

