/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.bundle.Resources;

class SmoothWeightedBalancer<T> {
    private final AtomicLong round = new AtomicLong(0L);
    private final ImmutableList<Item<T>> candidateList;
    private final int[] rounds;

    public SmoothWeightedBalancer(List<Item<T>> candidateList) {
        if (candidateList == null || candidateList.isEmpty()) {
            this.candidateList = ImmutableList.of();
            this.rounds = new int[0];
        } else {
            this.candidateList = ImmutableList.copyOf(this.check(candidateList));
            this.rounds = this.buildRoundIndex((List<Item<T>>)this.candidateList);
        }
    }

    private List<Item<T>> check(List<Item<T>> candidateList) {
        List<Item<T>> c1 = candidateList.size() > 20 ? new ArrayList<Item<T>>(candidateList.subList(0, 20)) : candidateList;
        ArrayList<Item<T>> c2 = new ArrayList<Item<T>>(c1.size());
        for (Item<T> i : c1) {
            if (((Item)i).weight > 100) {
                c2.add(new Item<Object>(100, ((Item)i).target));
                continue;
            }
            if (((Item)i).weight < 0) continue;
            c2.add(i);
        }
        if (c2.size() == 1) {
            Object target = ((Item)c2.get(0)).target;
            c2.clear();
            c2.add(new Item<Object>(1, target));
        }
        return c2;
    }

    private int[] buildRoundIndex(List<Item<T>> candidateList) {
        int[] weights = new int[candidateList.size()];
        for (int i = 0; i < candidateList.size(); ++i) {
            weights[i] = ((Item)candidateList.get(i)).weight;
        }
        int sum = 0;
        int n = weights.length;
        for (int i = 0; i < n; ++i) {
            int w = weights[i];
            if (w < 0) {
                w = 0;
            }
            sum += w;
        }
        if (sum == 0) {
            throw new IllegalArgumentException(weights.length + Resources.get((String)"bos-dbengine", (String)"SmoothWeightedBalancing_0", (String)"\u4efd\u6743\u91cd\u4e0d\u80fd\u5168<=0", (Object[])new Object[0]));
        }
        int[] ret = new int[sum];
        int[] cur_weights = new int[n];
        for (int i = 0; i < sum; ++i) {
            int index = -1;
            int total = 0;
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                cur_weights[n2] = cur_weights[n2] + weights[j];
                total += weights[j];
                if (index != -1 && cur_weights[index] >= cur_weights[j]) continue;
                index = j;
            }
            int n3 = index;
            cur_weights[n3] = cur_weights[n3] - total;
            ret[i] = index;
        }
        return ret;
    }

    public T select() {
        if (this.candidateList == null || this.candidateList.isEmpty()) {
            return null;
        }
        if (this.candidateList.size() == 1) {
            return (T)((Item)this.candidateList.get(0)).target;
        }
        long nextRound = this.round.getAndIncrement();
        int size = this.rounds.length;
        int idx = this.rounds[(int)(nextRound % (long)size)];
        return (T)((Item)this.candidateList.get(idx)).target;
    }

    public static class Item<T> {
        private final int weight;
        private final T target;

        public Item(int weight, T target) {
            this.weight = weight;
            this.target = target;
        }
    }
}

