/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.db.datasource.ConfiguredDataSourceParser;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class XMLConfigureDataSourceParser
implements ConfiguredDataSourceParser {
    private final Element root;

    public XMLConfigureDataSourceParser(Document document) {
        this.root = document.root();
        String version = this.root.child(0).getElementsByTag("version").first().text();
        if (!"1.0".equals(version)) {
            throw new IllegalArgumentException("version error");
        }
    }

    private String transDbType(String source) {
        if (source == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"dbtype can't be null"});
        }
        switch (source = source.toLowerCase(Locale.ENGLISH)) {
            default: {
                throw new KDException(BosErrorCode.bOS, new Object[]{"unknown db type: " + source});
            }
            case "clickhouse": {
                return "105";
            }
            case "hana": {
                return "101";
            }
            case "oracle": {
                return "0";
            }
            case "sqlserver": {
                return "6";
            }
            case "pg": {
                return "1";
            }
            case "mysql": {
                return "2";
            }
            case "derby": {
                return "10";
            }
            case "dm": {
                return "3";
            }
            case "gs": {
                return "4";
            }
            case "gs100": {
                return "5";
            }
            case "opengauss": {
                return "14";
            }
            case "kingbase": {
                return "15";
            }
            case "vastbase": {
                return "16";
            }
            case "tdsql": {
                return "17";
            }
            case "gbase": {
                return "18";
            }
            case "tidb": {
                return "19";
            }
            case "yasdb": {
                return "20";
            }
            case "oceanbase_oracle": 
        }
        return "21";
    }

    private HashMap<String, DBInstance> parseDBInstanceList(Element root) {
        Elements dbinstances = root.getElementsByTag("dbinstance");
        HashMap<String, DBInstance> dbMap = new HashMap<String, DBInstance>(dbinstances.size());
        for (Element element : dbinstances) {
            DBInstance instance = new DBInstance();
            instance.setDbtype(this.transDbType(this.getTagValue(element, "dbtype")));
            instance.setDbip(this.getTagValue(element, "host"));
            instance.setDbport(this.getTagValue(element, "port"));
            instance.setDBInsatnce(this.getTagValue(element, "db"));
            instance.setDbSchema(this.getTagValue(element, "schema"));
            instance.setDbuser(this.getTagValue(element, "username"));
            instance.setDbpassword(Encrypters.decode((String)this.getTagValue(element, "password")));
            String id = element.id();
            if (dbMap.containsKey(id)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"Duplicate dbinstance id:" + id});
            }
            dbMap.put(id, instance);
        }
        return dbMap;
    }

    private void buildDBInstance(HashMap<String, DBInstance> dbMap, List<DBInstance> instances, String routeKey, String instanceId, boolean readonly) {
        if (instanceId.trim().isEmpty()) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"dbinstance id is null or empty"});
        }
        DBInstance dbInstance = dbMap.get(instanceId);
        if (dbInstance == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"dbinstance id: " + instanceId + " not exists"});
        }
        DBInstance instance = dbInstance.copy();
        instance.setRouteKey(routeKey);
        instance.setReadOnly(String.valueOf(readonly ? 1 : 0));
        instance.setLoadFactor(readonly ? 1 : 0);
        instances.add(instance);
    }

    @Override
    public List<Account> parse() {
        HashMap<String, DBInstance> dbMap = this.parseDBInstanceList(this.root);
        Elements datacenters = this.root.getElementsByTag("datacenter");
        ArrayList<Account> accounts = new ArrayList<Account>(datacenters.size());
        for (Element element : datacenters) {
            String tenantId = element.attr("tenantId");
            String accountId = element.attr("accountId");
            Elements dbconfigs = element.getElementsByTag("dbconfig");
            ArrayList<DBInstance> instances = new ArrayList<DBInstance>(dbconfigs.size());
            for (Element dbconfig : dbconfigs) {
                Elements readonly;
                String routeKey = dbconfig.attr("routeKey");
                String instanceId = dbconfig.attr("dbinstance");
                if (!instanceId.isEmpty()) {
                    this.buildDBInstance(dbMap, instances, routeKey, instanceId, false);
                    continue;
                }
                Elements readwrite = dbconfig.getElementsByTag("readwrite");
                if (!readwrite.isEmpty()) {
                    if (readwrite.size() > 1) {
                        throw new KDException(BosErrorCode.bOS, new Object[]{"multiple readwrite dbinstance on " + dbconfig.toString()});
                    }
                    instanceId = ((Element)readwrite.get(0)).attr("dbinstance");
                    this.buildDBInstance(dbMap, instances, routeKey, instanceId, false);
                }
                if ((readonly = dbconfig.getElementsByTag("readonly")).isEmpty()) continue;
                if (readonly.size() > 1) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{"multiple readonly dbinstance on " + dbconfig.toString()});
                }
                instanceId = ((Element)readonly.get(0)).attr("dbinstance");
                this.buildDBInstance(dbMap, instances, routeKey, instanceId, true);
            }
            Account account = new Account();
            account.setAccountId(accountId);
            account.setTenantId(tenantId);
            account.setDBInstanceList(instances);
            accounts.add(account);
        }
        return accounts;
    }

    private String getTagValue(Element element, String tagName) {
        Element child = element.getElementsByTag(tagName).first();
        if (child == null) {
            return null;
        }
        return child.text();
    }
}

