/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource.urlcreator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.urlcreator.DataSourceURLCreator;
import kd.bos.ksql.CONSTANT;

public abstract class DataSourceURLCreatorBase
implements DataSourceURLCreator {
    @Override
    public String createShardingId(DBConfig dbConfig) {
        String sharingId = "";
        int p = dbConfig.getUrl().indexOf(63);
        String urlId = p == -1 ? dbConfig.getUrl() : dbConfig.getUrl().substring(0, p);
        sharingId = (dbConfig.getTenantId() + '#' + urlId + '#' + dbConfig.getAccountId()).toLowerCase();
        DBType dbType = dbConfig.getDBType();
        if (dbType == DBType.Oracle || dbType == DBType.DM || dbType == DBType.GS100) {
            sharingId = sharingId + '#' + dbConfig.getUser().toLowerCase();
        } else if (dbConfig.getSchema() != null && (dbType == DBType.PostgreSQL || dbType == DBType.GaussDB || dbType == DBType.Gauss200 || dbType == DBType.GS || dbType == DBType.Greenplum)) {
            sharingId = sharingId + '#' + dbConfig.getSchema().toLowerCase();
            if (CONSTANT.CONNECTION_SHARD && dbType == DBType.PostgreSQL && dbConfig.getMode() != null) {
                sharingId = sharingId + '#' + dbConfig.getMode().toLowerCase();
            }
            if (dbConfig.isCluster() && dbConfig.isReadOnly()) {
                sharingId = sharingId + "#readonly";
            }
        } else if (dbType == DBType.HANA) {
            sharingId = sharingId + '#' + dbConfig.getSchema() + '#' + dbConfig.getMode() + '#' + dbConfig.getUser();
        } else if (dbType == DBType.ClickHouse) {
            sharingId = sharingId + '#' + dbConfig.getSchema() + '#' + dbConfig.getMode() + '#' + dbConfig.getUser();
        }
        return sharingId;
    }

    protected static Map<String, String> toMapWithWhiteList(String url, Set<String> whiteList) {
        Map<String, String> map = DataSourceURLCreatorBase.toMap(url);
        HashMap<String, String> allow = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!whiteList.contains(entry.getKey())) continue;
            allow.put(entry.getKey(), entry.getValue());
        }
        return allow;
    }

    protected static Map<String, String> toMap(String appendURL) {
        String[] ps;
        if (appendURL.startsWith("&") || appendURL.startsWith("?")) {
            appendURL = appendURL.substring(1);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String s : ps = appendURL.split("&")) {
            int eq = s.indexOf(61);
            if (eq == -1 || eq == s.length() - 1) continue;
            map.put(s.substring(0, eq), s.substring(eq + 1));
        }
        return map;
    }

    protected static String appendURL(String url, Map<String, String> appendMap) {
        int p = url.indexOf(63);
        Map<Object, Object> existsMap = p != -1 ? DataSourceURLCreatorBase.toMap(url.substring(p + 1)) : new HashMap();
        StringBuilder sb = new StringBuilder(url);
        int link = p == -1 ? 63 : 38;
        for (Map.Entry<String, String> entry : appendMap.entrySet()) {
            String key = entry.getKey();
            if (existsMap.containsKey(key)) continue;
            sb.append((char)link).append(key).append('=').append(entry.getValue());
            link = 38;
        }
        return sb.toString();
    }
}

