/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource.urlcreator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.db.datasource.urlcreator.DataSourceURLCreatorBase;
import kd.bos.dc.api.model.DBInstance;

public class DataSourceURLCreatorGauss200Impl
extends DataSourceURLCreatorBase {
    private static final String PG_URL_APPEND = System.getProperty("db.pg.url.append", "");
    private static final String PG_CLUSTER_URL_APPEND = System.getProperty("db.pg.cluster.url.append", "");
    private static final Set<String> WHITE_LIST = new HashSet<String>();

    @Override
    public String createConnectionURL(DBInstance db) {
        String url = "";
        url = db.isCluster() ? this.generateClusterUrl(db) : this.generateURL(db);
        return url;
    }

    private String generateClusterUrl(DBInstance dbInstance) {
        String url = "jdbc:ksql:com.huawei.gauss200.jdbc.Driver:dbtype=gauss200:jdbc:gaussdb://" + dbInstance.getClusterDbUrl() + "/" + dbInstance.getDBInsatnce();
        url = dbInstance.isReadOnly() ? url + "?targetServerType=slave" : url + "?targetServerType=master";
        url = DataSourceURLCreatorGauss200Impl.appendURL(url, DataSourceURLCreatorGauss200Impl.toMapWithWhiteList(PG_CLUSTER_URL_APPEND, WHITE_LIST));
        return url;
    }

    public String generateURL(DBInstance dbInstance) {
        String url = "jdbc:ksql:com.huawei.gauss200.jdbc.Driver:dbtype=gauss200:jdbc:gaussdb://" + dbInstance.getDbip() + ":" + dbInstance.getDbport() + "/" + dbInstance.getDBInsatnce();
        url = DataSourceURLCreatorGauss200Impl.appendURL(url, DataSourceURLCreatorGauss200Impl.toMapWithWhiteList(PG_URL_APPEND, WHITE_LIST));
        return url;
    }

    static {
        WHITE_LIST.add("ssl");
        WHITE_LIST.add("sslfactory");
        WHITE_LIST.add("sslfactoryarg");
        WHITE_LIST.add("sslmode");
        WHITE_LIST.add("sslNegotiation");
        WHITE_LIST.add("sslcert");
        WHITE_LIST.add("sslkey");
        WHITE_LIST.add("sslrootcert");
        WHITE_LIST.add("sslhostnameverifier");
        WHITE_LIST.add("sslpasswordcallback");
        WHITE_LIST.add("sslpassword");
        WHITE_LIST.add("sslResponseTimeout");
        WHITE_LIST.add("loggerLevel");
        WHITE_LIST.add("loggerFile");
        WHITE_LIST.add("logUnclosedConnections");
        WHITE_LIST.add("channelBinding");
        WHITE_LIST.add("tcpNoDelay");
        WHITE_LIST.add("tcpKeepAlive");
    }
}

