/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource.urlcreator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.db.datasource.urlcreator.DataSourceURLCreatorBase;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.ksql.CONSTANT;

public class DataSourceURLCreatorPGImpl
extends DataSourceURLCreatorBase {
    private static final String PG_URL_APPEND = System.getProperty("db.pg.url.append", "");
    private static final String PG_CLUSTER_URL_APPEND = System.getProperty("db.pg.cluster.url.append", "");
    private static final String defaultAppender = "useCursorFetch=true&defaultRowFetchSize=5000";
    private static final Set<String> WHITE_LIST = new HashSet<String>();

    @Override
    public String createConnectionURL(DBInstance db) {
        String url = "";
        url = db.isCluster() ? this.generateClusterUrl(db) : this.generateURL(db);
        if (CONSTANT.CONNECTION_SHARD) {
            url = DataSourceURLCreatorPGImpl.appendURL(url, DataSourceURLCreatorPGImpl.toMap("currentSchema=" + db.getDbSchema()));
        }
        url = DataSourceURLCreatorPGImpl.appendURL(url, DataSourceURLCreatorPGImpl.toMap(defaultAppender));
        return url;
    }

    private String generateClusterUrl(DBInstance dbInstance) {
        String url = "jdbc:ksql:org.postgresql.Driver:dbtype=postgresql:jdbc:postgresql://" + dbInstance.getClusterDbUrl() + "/" + dbInstance.getDBInsatnce();
        url = dbInstance.isReadOnly() ? url + "?targetServerType=preferSecondary" : url + "?targetServerType=primary";
        url = DataSourceURLCreatorPGImpl.appendURL(url, DataSourceURLCreatorPGImpl.toMapWithWhiteList(PG_CLUSTER_URL_APPEND, WHITE_LIST));
        return url;
    }

    public String generateURL(DBInstance dbInstance) {
        String url = "jdbc:ksql:org.postgresql.Driver:dbtype=postgresql:jdbc:postgresql://" + dbInstance.getDbip() + ":" + dbInstance.getDbport() + "/" + dbInstance.getDBInsatnce();
        url = DataSourceURLCreatorPGImpl.appendURL(url, DataSourceURLCreatorPGImpl.toMapWithWhiteList(PG_URL_APPEND, WHITE_LIST));
        return url;
    }

    static {
        WHITE_LIST.add("ssl");
        WHITE_LIST.add("sslfactory");
        WHITE_LIST.add("sslfactoryarg");
        WHITE_LIST.add("sslmode");
        WHITE_LIST.add("sslNegotiation");
        WHITE_LIST.add("sslcert");
        WHITE_LIST.add("sslkey");
        WHITE_LIST.add("sslrootcert");
        WHITE_LIST.add("sslhostnameverifier");
        WHITE_LIST.add("sslpasswordcallback");
        WHITE_LIST.add("sslpassword");
        WHITE_LIST.add("sslResponseTimeout");
        WHITE_LIST.add("loggerLevel");
        WHITE_LIST.add("loggerFile");
        WHITE_LIST.add("logUnclosedConnections");
        WHITE_LIST.add("channelBinding");
        WHITE_LIST.add("tcpNoDelay");
        WHITE_LIST.add("tcpKeepAlive");
        WHITE_LIST.add("defaultRowFetchSize");
    }
}

