/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource.x;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.PWDChangedWatcher;
import kd.bos.db.datasource.x.GetConnectionHandler;
import kd.bos.db.datasource.x.XPoolStatus;
import kd.bos.util.ConfigurationUtil;

public abstract class XDataSource
implements DataSource,
AutoCloseable {
    protected static boolean allowClose = false;
    private DBConfig dbConfig;
    private GetConnectionHandler getConnectionHandler;
    protected DataSource ds;

    protected XDataSource(DataSource ds) {
        this.ds = ds;
    }

    public abstract String getUrl();

    public abstract void setUrl(String var1);

    public abstract String getUsername();

    public abstract void setUsername(String var1);

    public abstract String getPassword();

    public abstract void setPassword(String var1);

    public abstract void clearUsernameAndPassword();

    public abstract XPoolStatus getPoolStatus();

    public DBConfig getDBConfig() {
        return this.dbConfig;
    }

    public void setDBConfig(DBConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public GetConnectionHandler getGetConnectionHandler() {
        return this.getConnectionHandler;
    }

    public void setGetConnectionHandler(GetConnectionHandler getConnectionHandler) {
        this.getConnectionHandler = getConnectionHandler;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.ds.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.ds.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.ds.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ds.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ds.isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.getConnectionHandler == null) {
            return this.ds.getConnection();
        }
        return this.getConnectionHandler.getConnection(this.ds, this);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.ds.getConnection(username, password);
    }

    static {
        ConfigurationUtil.observeBoolean((String)"datasource.allowclose", (boolean)allowClose, b -> {
            allowClose = b;
        });
        if (Boolean.getBoolean("db.datasource.allowPWDChange")) {
            PWDChangedWatcher.startWatch();
        }
    }
}

