/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource.x;

import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.x.DBCPDataSource;
import kd.bos.db.datasource.x.DruidDataSource;
import kd.bos.db.datasource.x.XDataSource;
import kd.bos.db.datasource.x.XHikariDataSource;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;

public class XDataSourceFactory {
    private static final Log log = LogFactory.getLog(XDataSourceFactory.class);

    public static XDataSource dbcpDataSource(String dsName, Properties configProperties) throws Exception {
        BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)configProperties);
        ds.setJmxName(XDataSourceFactory.maskJMXName(dsName));
        ds.setDefaultAutoCommit(Boolean.TRUE);
        return new DBCPDataSource(ds);
    }

    public static XDataSource druidDataSource(String dsName, Properties configProperties) throws Exception {
        com.alibaba.druid.pool.DruidDataSource ds = (com.alibaba.druid.pool.DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)configProperties);
        ds.setName(XDataSourceFactory.maskJMXName(dsName));
        ds.setDefaultAutoCommit(true);
        return new DruidDataSource(ds);
    }

    public static XDataSource hikariDataSource(String dsName, DBConfig db, Properties configProperties) throws Exception {
        HikariConfig config = new HikariConfig();
        long idleTimeout = TimeUnit.MINUTES.toMillis(10L);
        long validationTimeout = TimeUnit.SECONDS.toMillis(10L);
        long maxLifetime = 0L;
        config.setConnectionTimeout((long)db.getPoolMaxWait());
        config.setMinimumIdle(db.getPoolMinIdle());
        config.setMaximumPoolSize(db.getPoolMaxActive());
        config.setIdleTimeout(idleTimeout);
        config.setValidationTimeout(validationTimeout);
        config.setMaxLifetime(0L);
        try {
            if (configProperties.containsKey("connectionTimeout")) {
                config.setConnectionTimeout(Long.parseLong(configProperties.getProperty("connectionTimeout")));
            }
            if (configProperties.containsKey("minimumIdle")) {
                config.setMinimumIdle(Integer.parseInt(configProperties.getProperty("minimumIdle")));
            }
            if (configProperties.containsKey("maximumPoolSize")) {
                config.setMaximumPoolSize(Integer.parseInt(configProperties.getProperty("maximumPoolSize")));
            }
            if (configProperties.containsKey("idleTimeout")) {
                config.setIdleTimeout(Long.parseLong(configProperties.getProperty("idleTimeout")));
            }
            if (configProperties.containsKey("validationTimeout")) {
                config.setValidationTimeout(Long.parseLong(configProperties.getProperty("validationTimeout")));
            }
            if (configProperties.containsKey("maxLifetime")) {
                config.setMaxLifetime(Long.parseLong(configProperties.getProperty("maxLifetime")));
            }
        }
        catch (Throwable e) {
            log.warn("\u6570\u636e\u6e90\u914d\u7f6e\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u5c06\u4f7f\u7528\u7f3a\u7701\u914d\u7f6e\u3002error_config=" + configProperties, e);
        }
        Properties dataSourceProperties = config.getDataSourceProperties();
        for (String key : configProperties.stringPropertyNames()) {
            if (!key.startsWith("dataSource.")) continue;
            dataSourceProperties.setProperty(key.substring("dataSource.".length()), dataSourceProperties.getProperty(key));
        }
        dataSourceProperties.setProperty("routeKey", db.getRouteKey());
        config.setDriverClassName(db.getDriver());
        config.setJdbcUrl(db.getUrl());
        config.setUsername(db.getUser());
        config.setPassword(db.getPassword());
        config.setConnectionTestQuery("SELECT 1");
        config.setPoolName(XDataSourceFactory.maskJMXName(dsName));
        config.setAutoCommit(true);
        return new XHikariDataSource(new HikariDataSource(config));
    }

    private static String maskJMXName(String dsName) {
        StringBuilder s = new StringBuilder(dsName.length());
        for (char ch : dsName.toCharArray()) {
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                s.append(ch);
                continue;
            }
            s.append('_');
        }
        return s.toString();
    }
}

