/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.meta;

import kd.bos.db.DBType;
import kd.bos.db.meta.IMeta;
import kd.bos.db.meta.impl.DMMetaImpl;
import kd.bos.db.meta.impl.GS100MetaImpl;
import kd.bos.db.meta.impl.GSMetaImpl;
import kd.bos.db.meta.impl.KingBaseMetaImpl;
import kd.bos.db.meta.impl.MysqlMetaImpl;
import kd.bos.db.meta.impl.OpenGaussMetaImpl;
import kd.bos.db.meta.impl.OracleMetaImpl;
import kd.bos.db.meta.impl.PostgreSqlMetaImpl;
import kd.bos.db.meta.impl.SqlServerMetaImpl;
import kd.bos.db.meta.impl.YasDBMetaImpl;

public class MetaFactory {
    public static IMeta getMeta(DBType dbType) {
        switch (dbType) {
            case DM: {
                return DMMetaImpl.instance;
            }
            case Oracle: 
            case OceanBase_Oracle: {
                return OracleMetaImpl.instance;
            }
            case MySQL: 
            case TDSQL: 
            case TiDB: {
                return MysqlMetaImpl.instance;
            }
            case PostgreSQL: 
            case Vastbase: 
            case Greenplum: 
            case Gbase: {
                return PostgreSqlMetaImpl.instance;
            }
            case GaussDB: {
                return OpenGaussMetaImpl.instance;
            }
            case KingBase: {
                return KingBaseMetaImpl.instance;
            }
            case GS: {
                return GSMetaImpl.instance;
            }
            case GS100: {
                return GS100MetaImpl.instance;
            }
            case SQLServer: {
                return SqlServerMetaImpl.instance;
            }
            case YasDB: {
                return YasDBMetaImpl.instance;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported dbType of %s.", dbType.name()));
    }
}

