/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.meta.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.meta.AbstractMeta;
import kd.bos.util.StringUtils;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.meta.Column;

public final class MysqlMetaImpl
extends AbstractMeta {
    public static final MysqlMetaImpl instance = new MysqlMetaImpl();

    @Override
    public List<Column> queryColumns(DBRoute dbRoute, String table) {
        String sql = "select column_name,data_type,character_maximum_length,numeric_precision,numeric_scale,is_nullable,column_default,ordinal_position,column_comment from information_schema.columns where table_schema = schema() and (table_name=?) order by ordinal_position";
        sql = this.dialect(NoShardingHint.genNoShardingSQL((String)sql));
        return DB.query(dbRoute, sql, new Object[]{table}, rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            try {
                while (rs.next()) {
                    String columnName = rs.getString("column_name");
                    String dataType = rs.getString("data_type");
                    long dataLength = this.parseLongNullAsZero(rs.getString("character_maximum_length"));
                    int dataPrecision = this.parseIntNullAsZero(rs.getString("numeric_precision"));
                    int dataScale = this.parseIntNullAsZero(rs.getString("numeric_scale"));
                    boolean nullable = "YES".equals(rs.getString("is_nullable"));
                    int columnId = rs.getInt("ordinal_position");
                    Object columnDefault = rs.getObject("column_default");
                    if (columnDefault == null) {
                        if ("bigint".equals(dataType) || "smallint".equals(dataType) || "int".equals(dataType) || "decimal".equals(dataType)) {
                            columnDefault = 0;
                        } else if ("varchar".equals(dataType)) {
                            columnDefault = Character.valueOf(' ');
                        } else if ("char".equals(dataType)) {
                            columnDefault = Character.valueOf(' ');
                        }
                    } else if ("char".equals(dataType)) {
                        columnDefault = StringUtils.isEmpty((String)((String)(columnDefault = ((String)columnDefault).trim()))) ? Character.valueOf(' ') : ("'0'".equals(columnDefault) ? Character.valueOf('0') : columnDefault);
                    }
                    Column column = new Column();
                    column.setColumnId(columnId);
                    column.setColumnName(columnName);
                    column.setDataType(dataType);
                    column.setDataLength(dataLength);
                    column.setDataPrecision(dataPrecision);
                    column.setDataScale(dataScale);
                    column.setNullable(nullable);
                    column.setColumnComment(rs.getString("column_comment"));
                    column.setDataDefault(columnDefault);
                    columnList.add(column);
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
            return columnList;
        });
    }
}

