/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.meta.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.meta.AbstractMeta;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.meta.Column;

public class OracleMetaImpl
extends AbstractMeta {
    public static final OracleMetaImpl instance = new OracleMetaImpl();

    @Override
    public List<Column> queryColumns(DBRoute dbRoute, String table) {
        String sql = "select c.column_name,data_type,char_length,data_precision,data_scale,nullable,data_default,column_id,co.comments  from user_tab_columns c left join user_col_comments co on c.table_name=co.table_name and c.column_name = co.column_name  where c.table_name=? order by column_id";
        sql = this.dialect(NoShardingHint.genNoShardingSQL((String)sql));
        return DB.query(dbRoute, sql, new Object[]{table.toUpperCase(Locale.ENGLISH)}, rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            try {
                while (rs.next()) {
                    String column_name = rs.getString("column_name");
                    String data_type = rs.getString("data_type");
                    String data_default = rs.getString("data_default");
                    long data_length = this.parseLongNullAsZero(rs.getString("char_length"));
                    int data_precision = this.parseIntNullAsZero(rs.getString("data_precision"));
                    int data_scale = this.parseIntNullAsZero(rs.getString("data_scale"));
                    boolean nullable = "Y".equals(rs.getString("nullable"));
                    int column_id = rs.getInt("column_id");
                    String comments = rs.getString("comments");
                    Column column = new Column();
                    column.setColumnId(column_id);
                    column.setColumnName(column_name);
                    column.setDataType(data_type);
                    column.setDataLength(data_length);
                    column.setDataPrecision(data_precision);
                    column.setDataScale(data_scale);
                    column.setNullable(nullable);
                    column.setDataDefault((Object)data_default);
                    column.setColumnComment(comments);
                    columnList.add(column);
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
            return columnList;
        });
    }
}

