/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.meta.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.meta.AbstractMeta;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.meta.Column;

public class PostgreSqlMetaImpl
extends AbstractMeta {
    public static final PostgreSqlMetaImpl instance = new PostgreSqlMetaImpl();

    @Override
    public List<Column> queryColumns(DBRoute dbRoute, String table) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select s.column_name,t.typname as data_type ,s.character_maximum_length,s.numeric_precision,s.numeric_scale,s.is_nullable,s.column_default,s.ordinal_position,col_description((table_schema||'.'||table_name)::regclass::oid, ordinal_position) as column_comment");
        sql.append(" from information_schema.columns s,pg_attribute a, pg_class c, pg_type t ");
        sql.append(" where  table_schema = current_schema () and s.table_name = c.relname and s.ordinal_position = a.attnum ");
        sql.append(" and a.attrelid = c.oid and a.atttypid = t.oid and s.table_name=? order by s.ordinal_position ");
        String querySql = this.dialect(NoShardingHint.genNoShardingSQL((String)sql.toString()));
        return DB.query(dbRoute, querySql, new Object[]{table.toLowerCase(Locale.ENGLISH)}, rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            try {
                while (rs.next()) {
                    String column_name = rs.getString("column_name");
                    String dataType = rs.getString("data_type");
                    long data_length = this.parseLongNullAsZero(rs.getString("character_maximum_length"));
                    int data_precision = this.parseIntNullAsZero(rs.getString("numeric_precision"));
                    int data_scale = this.parseIntNullAsZero(rs.getString("numeric_scale"));
                    boolean nullable = "YES".equals(rs.getString("is_nullable"));
                    int column_id = rs.getInt("ordinal_position");
                    String columnDefault = rs.getString("column_default");
                    if (columnDefault != null) {
                        columnDefault = columnDefault.split("::")[0];
                    }
                    Column column = new Column();
                    column.setColumnId(column_id);
                    column.setColumnName(column_name);
                    column.setDataType(dataType);
                    column.setDataDefault((Object)columnDefault);
                    column.setDataLength(data_length);
                    column.setDataPrecision(data_precision);
                    column.setDataScale(data_scale);
                    column.setNullable(nullable);
                    column.setColumnComment(rs.getString("column_comment"));
                    columnList.add(column);
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
            return columnList;
        });
    }
}

