/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.adapter;

import java.time.ZoneId;
import java.util.Collection;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.PKTempTableReleaseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableAdapter
implements kd.bos.db.temptable.pk.PKTempTable {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableAdapter.class);
    private final PKTempTable adapter;
    private long timeout = -1L;

    public PKTempTableAdapter(PKTempTable adapter) {
        this.adapter = adapter;
    }

    @Override
    public String getTable() {
        return this.adapter.getName();
    }

    public void insert(Collection<?> pks) {
        this.adapter.insert(pks);
    }

    @Override
    public void clear() {
        if (this.isReleased()) {
            throw new IllegalStateException("PKTempTable " + this.getTable() + " has released!");
        }
        if (this.isTimeout()) {
            throw new IllegalStateException("PKTempTable " + this.getTable() + " timeout, remaining " + this.getTimeoutRemaining() + "ms.");
        }
        this.adapter.clear();
    }

    @Override
    public void release() {
        try {
            this.adapter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getTimeout() {
        if (this.timeout < 0L) {
            return this.adapter.getBorrowTime().plusMinutes(PKTempTableConfig.getTableUseTimeoutMinute()).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        return this.timeout;
    }

    @Override
    public void setTimeout(long msTimeout) {
        this.timeout = msTimeout;
    }

    @Override
    public long getTimeoutRemaining() {
        return 0L;
    }

    @Override
    public boolean isTimeout() {
        return this.adapter.isTimeout();
    }

    @Override
    public boolean isReleased() {
        return this.adapter.isClosed();
    }

    @Override
    public void addReleaseListener(PKTempTableReleaseListener rl) {
        log.warn("PKTempTable release listener has be abandoned,register listener will not work.");
    }
}

