/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.manager.impl;

import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.db.pktemptable.PKTempTableHint;
import kd.bos.db.pktemptable.PKTempTableHints;
import kd.bos.db.pktemptable.PKTempTables;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.manager.impl.StandardTemptable;
import kd.bos.xdb.temptable.facade.TemptableType;
import kd.bos.xdb.temptable.manager.Temptable;
import kd.bos.xdb.temptable.manager.TemptableService;

public class StandardTemptableService
implements TemptableService {
    static final StandardTemptableService INSTANCE = new StandardTemptableService();

    public Temptable create(String routeKey, TemptableType type, int maxLength) {
        PKTempTableHint hint = null;
        if (type == TemptableType.BIG_STRING && maxLength > PKTempTableConfig.getBigStringLength()) {
            hint = PKTempTableHints.newHint(maxLength);
        }
        try (PKTempTableHint h = hint;){
            PKTempTable inner;
            switch (type) {
                case BIG_STRING: {
                    inner = PKTempTables.createPKBigString(DBRoute.of(routeKey));
                    break;
                }
                case PK_STRING: {
                    inner = PKTempTables.createPKString(DBRoute.of(routeKey));
                    break;
                }
                case PK_LONG: {
                    inner = PKTempTables.createPKLong(DBRoute.of(routeKey));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported temp table type: " + type);
                }
            }
            StandardTemptable standardTemptable = new StandardTemptable(inner);
            return standardTemptable;
        }
    }
}

