/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.metric.wrapper;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Reservoir;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.pktemptable.metric.MetricListener;
import kd.bos.metric.Histogram;
import kd.bos.metric.Snapshot;
import kd.bos.metric.core.SnapshotWrapper;

public class DynamicHistogramWrapper
extends Histogram
implements MetricListener {
    private final AtomicBoolean enable = new AtomicBoolean(false);
    private com.codahale.metrics.Histogram inner = new com.codahale.metrics.Histogram((Reservoir)new ExponentiallyDecayingReservoir());

    public DynamicHistogramWrapper() {
        super(null);
    }

    public void update(int value) {
        if (this.enable.get()) {
            this.inner.update(value);
        }
    }

    public long getCount() {
        if (this.enable.get()) {
            return this.inner.getCount();
        }
        return 0L;
    }

    public Snapshot getSnapshot() {
        if (this.enable.get()) {
            return new SnapshotWrapper(this.inner.getSnapshot());
        }
        return MockSnapshot.INSTANCE;
    }

    @Override
    public final void start() {
        this.enable.set(true);
    }

    @Override
    public final void stop() {
        this.enable.set(false);
    }

    static class MockSnapshot
    extends Snapshot {
        public static final MockSnapshot INSTANCE = new MockSnapshot();

        MockSnapshot() {
        }

        public double getValue(double v) {
            return 0.0;
        }

        public long[] getValues() {
            return new long[0];
        }

        public int size() {
            return 0;
        }

        public long getMax() {
            return 0L;
        }

        public double getMean() {
            return 0.0;
        }

        public long getMin() {
            return 0L;
        }

        public double getStdDev() {
            return 0.0;
        }

        public void dump(OutputStream outputStream) {
        }
    }
}

