/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.pktemptable.service.PKTempTableDaemonService;
import kd.bos.db.pktemptable.service.PKTempTableRequestContextRunnable;
import kd.bos.db.pktemptable.utils.DiscardUtil;
import kd.bos.db.pktemptable.utils.PKTempTableThreadUtils;
import kd.bos.db.pktemptable.utils.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPKTempTableDaemonService
implements PKTempTableDaemonService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Thread mainThread;
    protected final String threadName;
    protected final AtomicBoolean serviceStart = new AtomicBoolean(false);

    public AbstractPKTempTableDaemonService(String threadName) {
        this.threadName = threadName;
        PKTempTableRequestContextRunnable runnable = new PKTempTableRequestContextRunnable(() -> this.lambda$new$0(threadName));
        this.mainThread = new Thread(runnable);
        this.mainThread.setDaemon(true);
        this.mainThread.setName(threadName);
    }

    protected void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    @Override
    public void start() {
        TimerUtil.Timer timer = TimerUtil.newTimer();
        if (this.serviceStart.compareAndSet(false, true)) {
            this.mainThread.start();
            this.log.info("PKTempTableTask:{} start cost:{}ms", (Object)this.threadName, (Object)timer.cost());
        }
    }

    protected abstract void doTask() throws InterruptedException;

    protected abstract long pauseMillis();

    protected abstract long getDelayStartMillis();

    protected void beforeTask() {
        PKTempTableThreadUtils.resetThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$new$0(String threadName) {
        if (this.getDelayStartMillis() > 0L) {
            try {
                this.sleep(this.getDelayStartMillis());
            }
            catch (InterruptedException e) {
                this.log.warn("PKTempTableTask:{} delay start has interrupted.", (Object)threadName);
                return;
            }
        }
        while (true) {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    timer = TimerUtil.newTimer();
                    try {
                        this.beforeTask();
                        this.doTask();
                    }
                    finally {
                        cost = timer.cost();
                        parseMillis = this.pauseMillis();
                        if (cost < parseMillis) {
                            this.sleep(parseMillis - cost);
                            continue;
                        }
                        this.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                this.log.warn("PKTempTableTask:{} execute exception,msg: {}", new Object[]{threadName, ex.getMessage(), ex});
                if (!(ex instanceof InterruptedException)) {
                    try {
                        this.sleep(1000L);
                    }
                    catch (Exception ignored) {
                        DiscardUtil.discard();
                    }
                    continue;
                }
                return;
            }
            ** GOTO lbl-1000
            break;
        }
    }
}

