/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class Limiter {
    private static final Log log = LogFactory.getLog(Limiter.class);
    private static Method reflectAcquire;
    private static Field reflectActionOfCreate;
    private static Field reflectActionOfInsert;
    private static Field reflectLimitTypeOfDBInstance;
    private static Class<?> reflectLimitAcquireException;
    private static Exception reflectException;

    Limiter() {
    }

    private static String getDBInstanceByRouteKey(String routeKey) {
        RequestContextInfo rc = RequestContextInfo.get();
        DataSourceInfo dataSourceInfo = DataSourceFactory.getDataSource(rc.getTenantId(), routeKey, rc.getAccountId(), false);
        DBConfig dbConfig = dataSourceInfo.getDBConfig();
        if (dbConfig.isCluster()) {
            return dbConfig.getClusterDbUrl();
        }
        return String.format("%s:%d", dbConfig.getIp(), dbConfig.getPort());
    }

    public static Ticket acquire(Action action, String routeKey) {
        AutoCloseable impl = null;
        try (TXHandle handle = TX.requiresNew();){
            if (reflectException == null) {
                HashMap<Object, String> map = new HashMap<Object, String>();
                map.put(reflectLimitTypeOfDBInstance.get(null), Limiter.getDBInstanceByRouteKey(routeKey));
                Object implAction = action == Action.CREATE_TABLE ? reflectActionOfCreate.get(null) : reflectActionOfInsert.get(null);
                impl = (AutoCloseable)reflectAcquire.invoke(null, implAction, map);
            } else {
                log.warn("Cause an exception when create limiter reflector: " + reflectException.getMessage(), (Throwable)reflectException);
            }
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (exception instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)exception).getTargetException();
            }
            if (reflectException == null && reflectLimitAcquireException.isInstance(throwable) && throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            log.warn("Cause a unchecked exception when acquire limit ticket, detail message: " + exception.getMessage(), (Throwable)exception);
        }
        return new Ticket(impl);
    }

    static {
        reflectException = null;
        try {
            Class<?> reflectLimiterClass = Class.forName("kd.bos.limiter.impl.TmpTableLimiter");
            Class<?> reflectLimitTypeClass = Class.forName("kd.bos.limiter.constant.TmpTableLimitType");
            reflectLimitTypeOfDBInstance = reflectLimitTypeClass.getField("DB_INSTANCE");
            Class<?> reflectLimiterTmpTableInitConfigClass = Class.forName("kd.bos.limiter.impl.TmpTableInitConfig");
            Object reflectLimiterTmpTableInitConfig = reflectLimiterTmpTableInitConfigClass.newInstance();
            Method setTmpTableLimitTypeMethod = reflectLimiterTmpTableInitConfigClass.getMethod("setTmpTableLimitType", reflectLimitTypeClass);
            setTmpTableLimitTypeMethod.invoke(reflectLimiterTmpTableInitConfig, reflectLimitTypeOfDBInstance.get(null));
            Method setTenantIsolationMethod = reflectLimiterTmpTableInitConfigClass.getMethod("setTenantIsolation", Boolean.TYPE);
            setTenantIsolationMethod.invoke(reflectLimiterTmpTableInitConfig, true);
            Method setConcurrencyMethod = reflectLimiterTmpTableInitConfigClass.getMethod("setConcurrency", Long.TYPE);
            setConcurrencyMethod.invoke(reflectLimiterTmpTableInitConfig, 128);
            Method setLockTimeoutMethod = reflectLimiterTmpTableInitConfigClass.getMethod("setLockTimeout", Long.TYPE);
            setLockTimeoutMethod.invoke(reflectLimiterTmpTableInitConfig, 300);
            HashSet initConfigs = new HashSet();
            initConfigs.add(reflectLimiterTmpTableInitConfig);
            Method initConfigMethod = reflectLimiterClass.getMethod("init", Set.class);
            initConfigMethod.invoke(null, initConfigs);
            reflectAcquire = reflectLimiterClass.getMethod("acquire", Class.forName("kd.bos.limiter.constant.TmpTableAction"), Map.class);
            Class<?> reflectActionClass = Class.forName("kd.bos.limiter.constant.TmpTableAction");
            reflectActionOfCreate = reflectActionClass.getField("CREATE");
            reflectActionOfInsert = reflectActionClass.getField("INSERT");
            reflectLimitAcquireException = Class.forName("kd.bos.limiter.exception.AcquireFailedException");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            log.warn("Cause an error when init limiter, detail message: " + exception.getMessage(), (Throwable)exception);
            reflectException = exception;
        }
    }

    public static class Ticket
    implements AutoCloseable {
        private final AutoCloseable impl;

        public Ticket(AutoCloseable impl) {
            this.impl = impl;
        }

        @Override
        public void close() {
            if (this.impl != null) {
                try (TXHandle handle = TX.requiresNew();){
                    this.impl.close();
                }
                catch (Throwable throwable) {
                    log.warn("Cause an exception when release temp table limiter, detail message: " + throwable.getMessage(), throwable);
                }
            }
        }
    }

    public static enum Action {
        CREATE_TABLE,
        INSERT_DATA;

    }
}

