/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.PKTempTableHint;
import kd.bos.db.pktemptable.PKTempTableHints;
import kd.bos.db.pktemptable.PKTempTableType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.metric.PKTempTableCostMetric;
import kd.bos.db.pktemptable.metric.PKTempTableMetric;
import kd.bos.db.pktemptable.metric.PKTempTableMetrics;
import kd.bos.db.pktemptable.service.AbstractPKTempTable;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.service.InnerPKTempTableImpl;
import kd.bos.db.pktemptable.service.PKTempTableAsyncDropService;
import kd.bos.db.pktemptable.service.PKTempTableAsyncReuseService;
import kd.bos.db.pktemptable.service.PKTempTableClearService;
import kd.bos.db.pktemptable.service.PKTempTableDropDelayService;
import kd.bos.db.pktemptable.service.PKTempTableImpl;
import kd.bos.db.pktemptable.service.PKTempTableProducerService;
import kd.bos.db.pktemptable.service.PKTempTableReuseInTXService;
import kd.bos.db.pktemptable.service.PKTempTableRuntimeContext;
import kd.bos.db.pktemptable.service.PKTempTableService;
import kd.bos.db.pktemptable.service.PKTempTableUseTimeoutCheckService;
import kd.bos.db.pktemptable.table.PKTempTableOperator;
import kd.bos.db.pktemptable.table.PKTempTableOperatorFactory;
import kd.bos.db.pktemptable.utils.PKTempTableMetaUtils;
import kd.bos.db.tx.TX;
import kd.bos.metric.Counter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableCoreService
extends PKTempTableService {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableCoreService.class);
    private final DBRoute dbRoute;
    private final RequestContextInfo rc;
    private final Map<PKTempTableType, ArrayBlockingQueue<InnerPKTempTable>> queue;
    private final PKTempTableOperator tableOperator;
    private final PKTempTableUseTimeoutCheckService timeoutCheckService = PKTempTableUseTimeoutCheckService.getInstance();
    private final PKTempTableProducerService producer = PKTempTableProducerService.getInstance();
    private final PKTempTableMetric metric = PKTempTableMetrics.getDefault();
    private final Counter tableCounter = this.metric.tableQueueCounter();
    private final PKTempTableReuseInTXService txManagerService;
    public static final String LIMIT_SCENE = "TMP_TABLE";
    public static final ThreadLocal<Boolean> isLimited = new ThreadLocal();
    public static final String IS_LIMIT_WARN = "limit.tmptable.warn.enable";

    public PKTempTableCoreService(DBRoute dbRoute, RequestContextInfo rc, DBType type) {
        this.dbRoute = dbRoute;
        this.rc = rc;
        this.queue = new ConcurrentHashMap<PKTempTableType, ArrayBlockingQueue<InnerPKTempTable>>(PKTempTableType.values().length);
        for (PKTempTableType pkType : PKTempTableType.values()) {
            int queueSize = PKTempTableConfig.getTableSize();
            if (pkType == PKTempTableType.BIG_STRING) {
                queueSize = PKTempTableConfig.getBigStringTableSize();
            }
            if (PKTempTableConfig.isReuse()) {
                queueSize = PKTempTableConfig.getMaxTableSize();
            }
            this.queue.put(pkType, new ArrayBlockingQueue(queueSize));
        }
        PKTempTableMetaUtils.initMetaTable(dbRoute, rc);
        this.tableOperator = PKTempTableOperatorFactory.get(type);
        PKTempTableRuntimeContext.getInstance().register(this);
        this.startDaemonService();
        this.txManagerService = new PKTempTableReuseInTXService(this);
    }

    private void startDaemonService() {
        this.producer.start();
        this.timeoutCheckService.start();
        PKTempTableClearService.getInstance().start();
        PKTempTableAsyncDropService.getInstance().start();
        if (PKTempTableConfig.isReuse()) {
            PKTempTableAsyncReuseService.getInstance().start();
        }
        PKTempTableDropDelayService.getInstance().start();
    }

    @Override
    public AbstractPKTempTable createPKLong(boolean reuseInTx) {
        return this.getTable(PKTempTableType.LONG, reuseInTx);
    }

    @Override
    public AbstractPKTempTable createPKString(boolean reuseInTx) {
        return this.getTable(PKTempTableType.STRING, reuseInTx);
    }

    @Override
    public AbstractPKTempTable createPKBigString(boolean reuseInTx) {
        return this.getTable(PKTempTableType.BIG_STRING, reuseInTx);
    }

    private AbstractPKTempTable getTable(PKTempTableType type, boolean reuseInTx) {
        try (TraceSpan ts = Tracer.create((String)"temptable.get", (String)"temptable.get");){
            InnerPKTempTable table = reuseInTx && PKTempTableConfig.isTxTempTableReuse() && TX.inTX() ? this.txManagerService.borrow(type) : this.getTableImmediate(type);
            PKTempTableImpl pKTempTableImpl = new PKTempTableImpl(table, this.timeoutCheckService);
            return pKTempTableImpl;
        }
    }

    public InnerPKTempTable getTableImmediate(PKTempTableType type) {
        try (PKTempTableCostMetric ignored = this.metric.getTable();){
            InnerPKTempTable table = null;
            PKTempTableHint hint = PKTempTableHints.get();
            while (true) {
                if (hint != null) {
                    table = InnerPKTempTableImpl.create(this, type);
                    table.setReuse(false);
                    break;
                }
                table = this.queue.get((Object)type).poll();
                if (table == null) {
                    table = InnerPKTempTableImpl.create(this, type);
                    break;
                }
                this.tableCounter.dec();
                if (table.valid()) break;
                table.asyncDrop();
            }
            table.onUsing();
            this.producer.postRequest(this, type);
            InnerPKTempTable innerPKTempTable = table;
            return innerPKTempTable;
        }
    }

    public int queueSize(PKTempTableType type) {
        return this.queue.get((Object)type).size();
    }

    public boolean offer(InnerPKTempTable table) {
        boolean result = this.queue.get((Object)table.getType()).offer(table);
        if (result) {
            this.tableCounter.inc();
        }
        return result;
    }

    public boolean reuse(InnerPKTempTable table) {
        return this.offer(table);
    }

    public boolean canReuse(PKTempTableType type) {
        return PKTempTableConfig.isReuse() && this.queue.get((Object)type).size() > PKTempTableConfig.getMaxTableSize();
    }

    public DBRoute getRoute() {
        return this.dbRoute;
    }

    public RequestContextInfo getRc() {
        return this.rc;
    }

    public PKTempTableOperator getOperator() {
        return this.tableOperator;
    }

    public static boolean isWarn() {
        return Boolean.parseBoolean(System.getProperty(IS_LIMIT_WARN, "true"));
    }
}

