/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.time.LocalDateTime;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.metric.PKTempTableCostMetric;
import kd.bos.db.pktemptable.metric.PKTempTableMetric;
import kd.bos.db.pktemptable.metric.PKTempTableMetrics;
import kd.bos.db.pktemptable.service.PKTempTableDropDelayService;
import kd.bos.db.pktemptable.table.PKTempTableOperator;
import kd.bos.db.pktemptable.utils.PKTempTableMetaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableDropRequest {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableDropRequest.class);
    private final PKTempTableDropDelayService dropDelayService = PKTempTableDropDelayService.getInstance();
    private final RequestContextInfo rc;
    private final DBRoute route;
    private final String name;
    private final PKTempTableOperator operator;
    private final PKTempTableMetric metric = PKTempTableMetrics.getDefault();
    private final boolean retry;
    private int failTimes = 0;
    private LocalDateTime lastFailTime = LocalDateTime.now();

    PKTempTableDropRequest(RequestContextInfo rc, DBRoute route, String name, PKTempTableOperator operator, boolean retry) {
        this.rc = rc;
        this.route = route;
        this.name = name;
        this.operator = operator;
        this.retry = retry;
    }

    public void dropImmediate() {
        try (AutoCloseable ignored = this.rc.setupThreadRequestContext();){
            this.drop0();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canDropRetry() {
        return LocalDateTime.now().isAfter(this.lastFailTime.plusMinutes(PKTempTableConfig.getDropRetryTimeoutMinute()));
    }

    private void drop0() {
        try (PKTempTableCostMetric costMetric = this.metric.dropTable();){
            this.operator.drop(this.route, this.name);
            this.deleteMeta();
        }
        catch (Exception ex) {
            boolean exist = this.operator.validTable(this.route, this.name);
            if (!exist) {
                this.deleteMeta();
            }
            this.dropDelay(ex);
        }
    }

    private void dropDelay(Exception failException) {
        ++this.failTimes;
        this.lastFailTime = LocalDateTime.now();
        if (this.failTimes >= 100 && PKTempTableConfig.isLogRunTimeException()) {
            log.warn("Table:{} drop fail {} times,msg:{} .", new Object[]{this.name, this.failTimes, failException.getMessage(), failException});
        }
        if (!this.retry || this.failTimes >= 100) {
            return;
        }
        this.dropDelayService.offer(this);
    }

    private void deleteMeta() {
        try {
            PKTempTableMetaUtils.delete(this.route, this.name);
        }
        catch (Exception ex) {
            log.warn("Delete pkTempTable meta fail,msg:{} .", (Object)ex.getMessage(), (Object)ex);
        }
    }
}

