/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.metric.PKTempTableCostMetric;
import kd.bos.db.pktemptable.metric.PKTempTableMetric;
import kd.bos.db.pktemptable.metric.PKTempTableMetrics;
import kd.bos.db.pktemptable.table.PKTempTableOperator;
import kd.bos.db.pktemptable.utils.PKTempTableMetaUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableDropRequestGroup {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableDropRequestGroup.class);
    private final PKTempTableMetric metric = PKTempTableMetrics.getDefault();
    private final RequestContextInfo rc;
    private final DBRoute route;
    private final List<String> dropList;
    private final PKTempTableOperator operator;

    public PKTempTableDropRequestGroup(RequestContextInfo rc, DBRoute route, List<String> dropList, PKTempTableOperator operator) {
        this.rc = rc;
        this.route = route;
        this.dropList = dropList;
        this.operator = operator;
    }

    public void dropImmediate() {
        try (AutoCloseable ignored = this.rc.setupThreadRequestContext();){
            this.drop0();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drop0() {
        ArrayList<String> deleteList = new ArrayList<String>();
        for (String name : this.dropList) {
            try {
                PKTempTableCostMetric costMetric = this.metric.dropTable();
                Throwable throwable = null;
                try {
                    this.operator.drop(this.route, name);
                    deleteList.add(name);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (costMetric == null) continue;
                    if (throwable != null) {
                        try {
                            costMetric.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    costMetric.close();
                }
            }
            catch (Exception ex) {
                boolean exist = this.operator.validTable(this.route, name);
                if (exist) continue;
                deleteList.add(name);
            }
        }
        if (deleteList.isEmpty()) {
            return;
        }
        this.deleteMeta(deleteList);
    }

    private void deleteMeta(List<String> names) {
        try (TXHandle txHandle = TX.requiresNew("delete_tmp_meta");){
            PKTempTableMetaUtils.delete(this.route, names);
        }
        catch (Exception ex) {
            log.warn("Delete pkTempTable meta fail,msg:{} .", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void deleteMeta(String name) {
        try (TXHandle txHandle = TX.requiresNew("delete_tmp_meta");){
            PKTempTableMetaUtils.delete(this.route, name);
        }
        catch (Exception ex) {
            log.warn("Delete pkTempTable meta fail,msg:{} .", (Object)ex.getMessage(), (Object)ex);
        }
    }
}

