/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.PKTempTableType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.pktemptable.service.AbstractPKTempTable;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.service.PKTempTableUseTimeoutCheckService;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableImpl
extends AbstractPKTempTable {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableImpl.class);
    private final InnerPKTempTable inner;
    private final String name;
    private final RequestContextInfo rc;
    private final DBRoute route;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final LocalDateTime borrowTime;
    private final LocalDateTime borrowTimeout;
    private final PKTempTableType type;
    private final String snapshotToString;
    private final int version;
    private final PKTempTableUseTimeoutCheckService timeoutCheckService;
    private final Throwable borrowStack;

    PKTempTableImpl(InnerPKTempTable inner, PKTempTableUseTimeoutCheckService timeoutCheckService) {
        this.inner = inner;
        this.borrowTime = LocalDateTime.now();
        this.borrowTimeout = this.borrowTime.plusMinutes(PKTempTableConfig.getTableUseTimeoutMinute());
        this.name = inner.getName();
        this.rc = inner.getContext();
        this.route = inner.getRoute();
        this.type = inner.getType();
        this.snapshotToString = inner.toString();
        this.version = inner.getVersion();
        this.timeoutCheckService = timeoutCheckService;
        this.timeoutCheckService.register(this);
        this.borrowStack = PKTempTableConfig.isLogRunTimeException() ? new Throwable("PKTempTable:" + this.name + " borrow stack.") : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void insert(Collection<?> pks) {
        if (this.closed.get() || this.isTimeout()) {
            throw new PKTempTableException("PKTempTable insert data fail,table " + this.name + " has released or timeout.");
        }
        try (TraceSpan ts = Tracer.create((String)"temptable.init", (String)"temptable.init");){
            ts.addTag("count", String.valueOf(pks.size()));
            this.inner.insert(pks, this.version);
        }
    }

    @Override
    public boolean isTimeout() {
        return LocalDateTime.now().isAfter(this.borrowTimeout);
    }

    @Override
    public LocalDateTime getBorrowTime() {
        return this.borrowTime;
    }

    @Override
    public RequestContextInfo getContext() {
        return this.rc;
    }

    @Override
    public DBRoute getRoute() {
        return this.route;
    }

    @Override
    public PKTempTableType getType() {
        return this.type;
    }

    @Override
    public void clear() {
        if (!this.closed.get() && !this.isTimeout()) {
            this.inner.clear(this.version);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean force) {
        if (this.closed.compareAndSet(false, true)) {
            if (force && this.borrowStack != null && PKTempTableConfig.isLogRunTimeException()) {
                log.warn("PKTempTable be forced close.", this.borrowStack);
            }
            this.inner.close(this.version);
            this.timeoutCheckService.unRegister(this);
        }
    }

    public String toString() {
        return this.snapshotToString + "#v" + this.version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getPKFieldName() {
        return this.inner.getPKFieldName();
    }

    @Override
    public String getVersionFieldName() {
        return this.inner.getVersionFieldName();
    }

    @Override
    public boolean isReuseInTx() {
        return this.inner.isReuseInTx();
    }
}

