/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.db.pktemptable.PKTempTableType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.service.InnerPKTempTableImpl;
import kd.bos.db.pktemptable.service.PKTempTableCoreService;
import kd.bos.db.pktemptable.utils.DiscardUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableProducerRequest {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableProducerRequest.class);
    private static final Map<PKTempTableCoreService, Map<PKTempTableType, PKTempTableProducerRequest>> STORE = new ConcurrentHashMap<PKTempTableCoreService, Map<PKTempTableType, PKTempTableProducerRequest>>(2048);
    private final PKTempTableCoreService service;
    private final PKTempTableType type;
    private final ReentrantLock lock = new ReentrantLock(false);

    private PKTempTableProducerRequest(PKTempTableCoreService service, PKTempTableType type) {
        this.service = service;
        this.type = type;
    }

    static PKTempTableProducerRequest from(PKTempTableCoreService service, PKTempTableType type) {
        Map typeMap = STORE.computeIfAbsent(service, key -> new ConcurrentHashMap(PKTempTableType.values().length));
        return typeMap.computeIfAbsent(type, key -> new PKTempTableProducerRequest(service, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce() {
        if (this.service.queueSize(this.type) >= PKTempTableConfig.getTableSize()) {
            return;
        }
        boolean locked = this.lock.tryLock();
        if (!locked) {
            return;
        }
        try (AutoCloseable ignored = this.service.getRc().setupThreadRequestContext();){
            int tableSize;
            int n = tableSize = this.type == PKTempTableType.BIG_STRING ? PKTempTableConfig.getBigStringTableSize() : PKTempTableConfig.getTableSize();
            for (int cycle = PKTempTableConfig.getTableSize() > 10 ? PKTempTableConfig.getTableSize() / 2 : PKTempTableConfig.getTableSize(); this.service.queueSize(this.type) < tableSize && cycle > 0; --cycle) {
                InnerPKTempTableImpl table = InnerPKTempTableImpl.create(this.service, this.type);
                boolean full = this.service.offer(table);
                DiscardUtil.discard(full);
            }
        }
        catch (Exception ex) {
            log.warn("Offer table to queue fail,rc:{},route:{},msg:{}", new Object[]{this.service.getRc(), this.service.getRoute().getRouteKey(), ex.getMessage(), ex});
        }
        finally {
            this.lock.unlock();
        }
    }
}

