/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.service.PKTempTableCoreService;
import kd.bos.db.pktemptable.table.PKTempTableOperator;

public class PKTempTableRuntimeContext {
    private static final PKTempTableRuntimeContext INSTANCE = new PKTempTableRuntimeContext();
    private final Map<String, Context> store = new ConcurrentHashMap<String, Context>(64);

    static PKTempTableRuntimeContext getInstance() {
        return INSTANCE;
    }

    public void register(PKTempTableCoreService service) {
        RequestContextInfo rc = service.getRc();
        DBRoute route = service.getRoute();
        this.store.computeIfAbsent(rc.getTenantId() + '#' + rc.getAccountId() + '#' + route.getRouteKey(), k -> new Context(rc, route, service.getOperator()));
    }

    public List<Context> snapshotRuntimeContext() {
        return new ArrayList<Context>(this.store.values());
    }

    public static class Context {
        private final RequestContextInfo rc;
        private final DBRoute route;
        private final PKTempTableOperator operator;

        public Context(RequestContextInfo rc, DBRoute route, PKTempTableOperator operator) {
            this.rc = rc;
            this.route = route;
            this.operator = operator;
        }

        public RequestContextInfo getRc() {
            return this.rc;
        }

        public DBRoute getRoute() {
            return this.route;
        }

        public PKTempTableOperator getOperator() {
            return this.operator;
        }

        public String toString() {
            return "Context{rc=" + this.rc + ", route=" + this.route + '}';
        }
    }
}

