/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.pktemptable.service.PKTempTableCoreService;
import kd.bos.db.pktemptable.service.PKTempTableService;
import kd.bos.db.pktemptable.utils.OnlyUseFor;

@OnlyUseFor(value={"bos-dbengine", "bos-ormengine"})
public class PKTempTableServiceFactory {
    private static final Map<String, PKTempTableService> SERVICE_STORE = new ConcurrentHashMap<String, PKTempTableService>(64);
    private static final Map<String, String> PHYSICAL_KEY_MAP = new ConcurrentHashMap<String, String>(64);

    private PKTempTableServiceFactory() {
    }

    public static PKTempTableService getService(DBRoute route) {
        RequestContextInfo rc = RequestContextInfo.get();
        LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of(ArchiveRoute.getMapRoute(route.getRouteKey()));
        DBRoute newRoute = logicArchiveRoute.isCurrentArchive() ? route : DBRoute.of(logicArchiveRoute.getRealArchiveKey());
        String routeKey = newRoute.getRouteKey() + '#' + rc.getTenantId() + '#' + rc.getAccountId();
        DBConfig config = PKTempTableServiceFactory.loadForWriteConfig(newRoute, rc.getTenantId(), rc.getAccountId());
        String physicalDbKey = PHYSICAL_KEY_MAP.computeIfAbsent(routeKey, k -> config.getSharingId());
        return SERVICE_STORE.computeIfAbsent(physicalDbKey, k -> {
            DBType dbType = config.getDBType();
            return new PKTempTableCoreService(newRoute, rc, dbType);
        });
    }

    private static DBConfig loadForWriteConfig(DBRoute route, String tenantId, String accountId) {
        return DataSourceFactory.getDataSource(tenantId, route.getRouteKey(), accountId, false).getDBConfig();
    }
}

