/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.metric.PKTempTableMetrics;
import kd.bos.db.pktemptable.service.AbstractPKTempTable;
import kd.bos.db.pktemptable.service.PKTempTableDaemonService;
import kd.bos.db.pktemptable.utils.ExecutorServiceUtil;
import kd.bos.metric.Counter;

public class PKTempTableUseTimeoutCheckService
implements PKTempTableDaemonService {
    private static final PKTempTableUseTimeoutCheckService INSTANCE = new PKTempTableUseTimeoutCheckService();
    private final Map<String, LinkedBlockingDeque<AbstractPKTempTable>> mapQueue = new ConcurrentHashMap<String, LinkedBlockingDeque<AbstractPKTempTable>>(64);
    private final Counter queueCounter = PKTempTableMetrics.getDefault().useTimeCheckQueueCounter();
    private final AtomicBoolean started = new AtomicBoolean(false);

    PKTempTableUseTimeoutCheckService() {
    }

    public static PKTempTableUseTimeoutCheckService getInstance() {
        return INSTANCE;
    }

    public void register(AbstractPKTempTable table) {
        String key = this.getKey(table);
        LinkedBlockingDeque queue = this.mapQueue.computeIfAbsent(key, k -> new LinkedBlockingDeque());
        boolean result = queue.offer(table);
        if (result) {
            this.queueCounter.inc();
        }
    }

    public void unRegister(AbstractPKTempTable table) {
        String key = this.getKey(table);
        LinkedBlockingDeque queue = this.mapQueue.computeIfAbsent(key, k -> new LinkedBlockingDeque());
        boolean result = queue.remove(table);
        if (result) {
            this.queueCounter.dec();
        }
    }

    private String getKey(AbstractPKTempTable table) {
        RequestContextInfo rc = table.getContext();
        return rc.getTenantId() + '#' + rc.getAccountId();
    }

    private void doTask() {
        Collection<LinkedBlockingDeque<AbstractPKTempTable>> values = this.mapQueue.values();
        for (LinkedBlockingDeque<AbstractPKTempTable> queue : values) {
            if (queue == null) continue;
            AbstractPKTempTable table = queue.peek();
            while (table != null && (table.isTimeout() || table.isClosed())) {
                queue.poll();
                this.queueCounter.dec();
                if (!table.isClosed()) {
                    table.close(true);
                }
                table = queue.peek();
            }
        }
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            ScheduledExecutorService reuseExecutor = ExecutorServiceUtil.newSingleThreadScheduledExecutor(this.getClass().getSimpleName());
            reuseExecutor.scheduleWithFixedDelay(this::doTask, 0L, 5L, TimeUnit.MINUTES);
        }
    }
}

