/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.table.CommonPKTempTableOperator;
import kd.bos.db.pktemptable.table.ddl.ClickHouseDialectDDLSqlProvider;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseSqlPKTempTableOperator
extends CommonPKTempTableOperator {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseSqlPKTempTableOperator.class);
    private final ClickHouseDialectDDLSqlProvider provider = new ClickHouseDialectDDLSqlProvider();

    @Override
    public void create(DBRoute route, InnerPKTempTable table) {
        try {
            TX.__setRouteForceMaster(route.getRouteKey());
            String sql = this.provider.getCreateTempTableSql(table, new ClickHouseDialectDDLSqlProvider.CreateTableOption());
            try (TXHandle ignored = TX.requiresNew("temp_create");){
                DB.execute(route, sql);
            }
        }
        catch (Exception e) {
            log.warn("Create PKTempTable:{} fail,msg: {}", (Object)table.getName(), (Object)e.getMessage());
            throw new PKTempTableException("Create PKTempTable:" + table.getName() + "fail,msg: " + e.getMessage(), e);
        }
    }
}

