/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table;

import java.util.HashMap;
import java.util.Map;
import kd.bos.db.DBType;
import kd.bos.db.pktemptable.table.ClickHouseSqlPKTempTableOperator;
import kd.bos.db.pktemptable.table.CommonPKTempTableOperator;
import kd.bos.db.pktemptable.table.DMPKTempTableOperator;
import kd.bos.db.pktemptable.table.MySQLPKTempTableOperator;
import kd.bos.db.pktemptable.table.OraclePKTempTableOperator;
import kd.bos.db.pktemptable.table.PKTempTableOperator;
import kd.bos.db.pktemptable.table.PostgreSqlPKTempTableOperator;
import kd.bos.db.pktemptable.table.SQLServerPKTempTableOperator;
import kd.bos.db.pktemptable.table.TDSQLPKTempTableOperator;
import kd.bos.db.pktemptable.table.TiDBPKTempTableOperator;
import kd.bos.db.pktemptable.table.VastbasePKTempTableOperator;
import kd.bos.db.pktemptable.table.YasDBPKTempTableOperator;

public class PKTempTableOperatorFactory {
    private static final Map<DBType, PKTempTableOperator> OPERATOR_CACHE = new HashMap<DBType, PKTempTableOperator>(10);
    private static final PKTempTableOperator DEFAULT = new CommonPKTempTableOperator();

    public static PKTempTableOperator get(DBType dbType) {
        PKTempTableOperator operator = OPERATOR_CACHE.get((Object)dbType);
        if (operator != null) {
            return operator;
        }
        return DEFAULT;
    }

    public static PKTempTableOperator getDefault() {
        return DEFAULT;
    }

    static {
        OPERATOR_CACHE.put(DBType.MySQL, new MySQLPKTempTableOperator());
        OPERATOR_CACHE.put(DBType.PostgreSQL, new PostgreSqlPKTempTableOperator());
        OPERATOR_CACHE.put(DBType.Oracle, new OraclePKTempTableOperator());
        OPERATOR_CACHE.put(DBType.SQLServer, new SQLServerPKTempTableOperator());
        OPERATOR_CACHE.put(DBType.DM, new DMPKTempTableOperator());
        OPERATOR_CACHE.put(DBType.TDSQL, new TDSQLPKTempTableOperator());
        OPERATOR_CACHE.put(DBType.TiDB, new TiDBPKTempTableOperator());
        OPERATOR_CACHE.put(DBType.Vastbase, new VastbasePKTempTableOperator());
        OPERATOR_CACHE.put(DBType.YasDB, new YasDBPKTempTableOperator());
        OPERATOR_CACHE.put(DBType.OceanBase_Oracle, new OraclePKTempTableOperator());
        OPERATOR_CACHE.put(DBType.ClickHouse, new ClickHouseSqlPKTempTableOperator());
    }
}

