/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkData;
import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.sql.Connection;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.pktemptable.PKTempTableType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.id.ID;

public class SQLServerBulkInsert {
    private final SQLServerConnection conn;
    private final InnerPKTempTable table;
    private final Collection<?> noNullValueSet;
    private final int version;

    public SQLServerBulkInsert(SQLServerConnection conn, InnerPKTempTable table, Collection<?> noNullValueSet, int version) {
        this.conn = conn;
        this.table = table;
        this.noNullValueSet = noNullValueSet;
        this.version = version;
    }

    public void insert() throws SQLServerException {
        SQLServerBulkInsertRecord bulk = new SQLServerBulkInsertRecord(this.noNullValueSet, this.version, this.table.getType());
        SQLServerBulkCopy bulkCopy = new SQLServerBulkCopy((Connection)this.conn);
        bulkCopy.setDestinationTableName(this.table.getName());
        bulkCopy.writeToServer((ISQLServerBulkData)bulk);
    }

    private static class ColumnMetadata {
        public final String columnName;
        public final int columnType;
        public final int precision;
        public final int scale;

        public ColumnMetadata(String columnName, int columnType, int precision, int scale) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.precision = precision;
            this.scale = scale;
        }
    }

    public static class SQLServerBulkInsertRecord
    implements ISQLServerBulkRecord {
        private Map<Integer, ColumnMetadata> columnMetadata = new HashMap<Integer, ColumnMetadata>();
        private int position = -1;
        private final List<Object[]> data;
        private Object[] current;

        public SQLServerBulkInsertRecord(Collection<?> noNullValueSet, int version, PKTempTableType type) {
            this.data = new ArrayList<Object[]>(noNullValueSet.size());
            boolean tableWithPk = PKTempTableConfig.isTableCreateWithPk();
            switch (type) {
                case STRING: {
                    this.columnMetadata.put(1, new ColumnMetadata("FID", -9, 32, 0));
                    break;
                }
                case LONG: {
                    this.columnMetadata.put(1, new ColumnMetadata("FID", -5, 0, 0));
                    break;
                }
                case BIG_STRING: {
                    this.columnMetadata.put(1, new ColumnMetadata("FID", -9, PKTempTableConfig.getBigStringLength(), 0));
                    break;
                }
                default: {
                    throw new PKTempTableException("Unknown pkTempTable type:" + (Object)((Object)type));
                }
            }
            if (tableWithPk) {
                this.columnMetadata.put(2, new ColumnMetadata("FPKID", -5, 0, 0));
            }
            this.columnMetadata.put(tableWithPk ? 3 : 2, new ColumnMetadata("FVERSION", 4, 0, 0));
            for (Object value : noNullValueSet) {
                Object v = type == PKTempTableType.LONG && !(value instanceof Long) ? (value instanceof Number ? Long.valueOf(((Number)value).longValue()) : Long.valueOf(Long.parseLong(value.toString()))) : (type != PKTempTableType.LONG && !(value instanceof String) ? value.toString() : value);
                if (tableWithPk) {
                    this.data.add(new Object[]{v, ID.genLongId(), version});
                    continue;
                }
                this.data.add(new Object[]{v, version});
            }
        }

        public Set<Integer> getColumnOrdinals() {
            return this.columnMetadata.keySet();
        }

        public String getColumnName(int index) {
            return this.columnMetadata.get((Object)Integer.valueOf((int)index)).columnName;
        }

        public int getColumnType(int index) {
            return this.columnMetadata.get((Object)Integer.valueOf((int)index)).columnType;
        }

        public int getPrecision(int index) {
            return this.columnMetadata.get((Object)Integer.valueOf((int)index)).precision;
        }

        public int getScale(int index) {
            return this.columnMetadata.get((Object)Integer.valueOf((int)index)).scale;
        }

        public boolean isAutoIncrement(int index) {
            return false;
        }

        public void addColumnMetadata(int positionInFile, String name, int jdbcType, int precision, int scale, DateTimeFormatter dateTimeFormatter) throws SQLServerException {
            throw new PKTempTableException("Unsupported method addColumnMetadata.");
        }

        public void addColumnMetadata(int positionInFile, String name, int jdbcType, int precision, int scale) throws SQLServerException {
            throw new PKTempTableException("Unsupported method addColumnMetadata.");
        }

        public void setTimestampWithTimezoneFormat(String datetimeFormat) {
            throw new PKTempTableException("Unsupported method setTimestampWithTimezoneFormat.");
        }

        public void setTimestampWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
            throw new PKTempTableException("Unsupported method setTimestampWithTimezoneFormat.");
        }

        public void setTimeWithTimezoneFormat(String timeFormat) {
            throw new PKTempTableException("Unsupported method setTimeWithTimezoneFormat.");
        }

        public void setTimeWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
            throw new PKTempTableException("Unsupported method setTimeWithTimezoneFormat.");
        }

        public DateTimeFormatter getColumnDateTimeFormatter(int column) {
            throw new PKTempTableException("Unsupported method getColumnDateTimeFormatter.");
        }

        public Object[] getRowData() {
            if (this.position < 0) {
                throw new PKTempTableException("Before getRowData should call next.");
            }
            return this.current;
        }

        public boolean next() {
            ++this.position;
            if (this.position >= this.data.size()) {
                return false;
            }
            this.current = this.data.get(this.position);
            return this.current != null;
        }
    }
}

