/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.table.CommonPKTempTableOperator;
import kd.bos.db.pktemptable.table.ddl.VastbaseDDLSqlProvider;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VastbasePKTempTableOperator
extends CommonPKTempTableOperator {
    private static final Logger log = LoggerFactory.getLogger(VastbasePKTempTableOperator.class);
    private final VastbaseDDLSqlProvider provider = new VastbaseDDLSqlProvider();

    @Override
    public void create(DBRoute route, InnerPKTempTable table) {
        try {
            TX.__setRouteForceMaster(route.getRouteKey());
            boolean withIndex = PKTempTableConfig.isTempWithIndex();
            boolean withPk = PKTempTableConfig.isTableCreateWithPk();
            int bigStringLength = PKTempTableConfig.getBigStringLength();
            int pkStringLength = PKTempTableConfig.getPkStringLength();
            List<String> sqlList = this.provider.getCreateTempTableSql(table, withIndex, withPk, bigStringLength, pkStringLength);
            try (TXHandle ignored = TX.requiresNew("temp_create");){
                for (String sql : sqlList) {
                    DB.execute(route, sql);
                }
            }
        }
        catch (Exception e) {
            log.warn("Create PKTempTable:{} fail,msg: {}", (Object)table.getName(), (Object)e.getMessage());
            throw new PKTempTableException("Create PKTempTable:" + table.getName() + "fail,msg: " + e.getMessage(), e);
        }
    }

    @Override
    public void insert(DBRoute route, InnerPKTempTable table, Collection<?> noNullValueSet, int version) {
        this.logInsertStack(noNullValueSet.size());
        String pkTable = table.getName();
        TX.__setRouteForceMaster(route.getRouteKey());
        try (TXHandle ignored = TX.requiresNew("temp_insert");
             DelegateConnection conn = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck(route.getRouteKey(), false);){
            boolean tableWithPk = PKTempTableConfig.isTableCreateWithPk();
            String sql = VastbasePKTempTableOperator.wrapDialectNoShardingSQL("COPY " + pkTable + "(FID,FVERSION) FROM STDIN DELIMITER AS ','");
            if (tableWithPk) {
                sql = VastbasePKTempTableOperator.wrapDialectNoShardingSQL("/*with_pk*/COPY " + pkTable + "(FID,FPKID,FVERSION) FROM STDIN DELIMITER AS ','");
            }
            VastbasePKTempTableOperator.logInsertPKSelfExecuteSQL(sql, conn, route);
            int w50 = 500000;
            StringBuilder sb = new StringBuilder(Math.min(noNullValueSet.size(), w50) * 19);
            int idx = 0;
            long copyCount = 0L;
            boolean executeCopyIn = false;
            long begin = System.currentTimeMillis();
            for (Object value : noNullValueSet) {
                sb.append(value);
                if (tableWithPk) {
                    sb.append(',').append(ID.genLongId());
                }
                sb.append(',').append(version);
                sb.append("\n");
                executeCopyIn = true;
                if (++idx % w50 != 0) continue;
                sb.setLength(sb.length() - 1);
                copyCount += this.copyIn(sb, sql, conn);
                executeCopyIn = false;
                sb = new StringBuilder(Math.min(noNullValueSet.size(), w50) * 19);
            }
            if (executeCopyIn) {
                sb.setLength(sb.length() - 1);
                copyCount += this.copyIn(sb, sql, conn);
            }
            if (log.isInfoEnabled()) {
                log.info("TempTable {} use copy insert succeed, cost ={}ms, copyCount = {}, toInsertCount = {}", new Object[]{pkTable, System.currentTimeMillis() - begin, copyCount, noNullValueSet.size()});
            }
        }
        catch (Exception ex) {
            log.warn("Vastbase use copy in {} fail,will use batch insert . fail msg={}", (Object)pkTable, (Object)ex.getMessage());
            super.insert(route, table, noNullValueSet, version);
        }
    }

    /*
     * Exception decompiling
     */
    private long copyIn(StringBuilder sb, String sql, DelegateConnection conn) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class ConnectionAutoCommitResetter
    implements AutoCloseable {
        private final DelegateConnection connection;
        private final boolean autoCommit;

        private ConnectionAutoCommitResetter(DelegateConnection connection, boolean currentAutoCommit) throws SQLException {
            this.connection = connection;
            this.autoCommit = connection.getAutoCommit();
            connection.__setAutoCommit(currentAutoCommit);
        }

        public static ConnectionAutoCommitResetter currentAutoCommit(DelegateConnection conn, boolean currentAutoCommit) throws SQLException {
            return new ConnectionAutoCommitResetter(conn, currentAutoCommit);
        }

        @Override
        public void close() throws Exception {
            if (this.connection != null) {
                this.connection.__setAutoCommit(this.autoCommit);
            }
        }
    }
}

