/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table;

import com.google.common.collect.Iterables;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.table.CommonPKTempTableOperator;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.xdb.QueryTimeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YasDBPKTempTableOperator
extends CommonPKTempTableOperator {
    private static final Logger log = LoggerFactory.getLogger(YasDBPKTempTableOperator.class);

    @Override
    public void insert(DBRoute route, InnerPKTempTable table, Collection<?> noNullValueSet, int version) {
        String pkTable = table.getName();
        this.logInsertStack(noNullValueSet.size());
        TX.__setRouteForceMaster(route.getRouteKey());
        try (TXHandle ignored = TX.notSupported("temp_insert");
             DelegateConnection con = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck(route.getRouteKey(), false);){
            boolean tableWithPk = PKTempTableConfig.isTableCreateWithPk();
            String sizeComment = "/*ids_" + noNullValueSet.size() + "*/";
            int parallel = noNullValueSet.size() >= 100000 ? 4 : 2;
            String sql = YasDBPKTempTableOperator.wrapDialectNoShardingSQL(sizeComment + "INSERT INTO /*+ append parallel(" + parallel + ")*/ " + pkTable + "(FID,FVERSION) VALUES(?,?)");
            if (tableWithPk) {
                sql = YasDBPKTempTableOperator.wrapDialectNoShardingSQL(sizeComment + "INSERT INTO /*+ append parallel(" + parallel + ")*/ " + pkTable + "(FID,FPKID,FVERSION) VALUES(?,?,?)");
            }
            YasDBPKTempTableOperator.logInsertPKSelfExecuteSQL(sql, con, route);
            int batchExecuteSplitSize = 5000;
            for (List batchValues : Iterables.partition(noNullValueSet, (int)batchExecuteSplitSize)) {
                PreparedStatement ps = con.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    for (Object v : batchValues) {
                        ps.setObject(1, v);
                        if (tableWithPk) {
                            ps.setLong(2, ID.genLongId());
                        }
                        ps.setInt(tableWithPk ? 3 : 2, version);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps == null) continue;
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            log.warn("Insert data in {} fail.msg={}", (Object)pkTable, (Object)e.getMessage());
            throw new PKTempTableException("Insert data in temptable fail.", e);
        }
    }

    @Override
    public void drop(DBRoute route, InnerPKTempTable table) {
        TX.__setRouteForceMaster(route.getRouteKey());
        try (TXHandle ignored = TX.requiresNew("drop__pk_temp_table");
             QueryTimeout ignored1 = DB.timeout(PKTempTableConfig.getDropTimeoutSecond());){
            String truncateSQL = YasDBPKTempTableOperator.wrapDialectNoShardingSQL("TRUNCATE TABLE " + table.getName());
            String dropSQL = YasDBPKTempTableOperator.wrapDialectNoShardingSQL("DROP TABLE " + table.getName() + " PURGE");
            DB.execute(route, truncateSQL);
            DB.execute(route, dropSQL);
        }
        catch (Exception ex) {
            log.warn("Drop PKTempTable fail,msg: {}", (Object)ex.getMessage());
            throw new PKTempTableException("Drop TempTable fail." + ex.getMessage(), ex);
        }
    }

    @Override
    public void drop(DBRoute route, String name) {
        TX.__setRouteForceMaster(route.getRouteKey());
        try (TXHandle ignored = TX.requiresNew("drop__pk_temp_table");
             QueryTimeout ignored1 = DB.timeout(PKTempTableConfig.getDropTimeoutSecond());){
            String dropSQL = YasDBPKTempTableOperator.wrapDialectNoShardingSQL("DROP TABLE " + name + " PURGE");
            DB.execute(route, dropSQL);
        }
        catch (Exception ex) {
            log.warn("Drop PKTempTable fail,msg: {}", (Object)ex.getMessage());
            throw new PKTempTableException("Drop TempTable fail." + ex.getMessage(), ex);
        }
    }
}

