/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table.ddl;

import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.service.InnerPKTempTable;

public class ClickHouseDialectDDLSqlProvider {
    public String getCreateTempTableSql(InnerPKTempTable table, CreateTableOption option) {
        String tableName = table.getName().toLowerCase();
        int bigStringLength = option.bigStringLength;
        StringBuilder builder = new StringBuilder("/*dialect*//*NO_SHARDING*/CREATE TABLE ");
        builder.append(tableName);
        builder.append("(");
        builder.append("fid ");
        switch (table.getType()) {
            case STRING: {
                builder.append(String.format("FixedString(%d) DEFAULT ' ',", option.pkStringLength));
                break;
            }
            case LONG: {
                builder.append("Int64 DEFAULT 0,");
                break;
            }
            case BIG_STRING: {
                if (option.bigStringLength <= 0) {
                    bigStringLength = 80;
                }
                builder.append("FixedString(").append(bigStringLength).append(")DEFAULT ' ',");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown temp table type.");
            }
        }
        if (option.withPK) {
            builder.append("fpkid Int64 DEFAULT 0,");
        }
        builder.append("fversion Int64 DEFAULT 0)");
        builder.append("ENGINE=MergeTree() ");
        builder.append("order by(fid, ");
        if (option.withPK) {
            builder.append("fpkid, ");
        }
        builder.append("fversion); ");
        return builder.toString();
    }

    public String getCreateMetaTableSql() {
        return "CREATE TABLE t_pktemp_meta (ftable_name FixedString(50) NOT NULL, fcreate_time datetime DEFAULT NULL) ENGINE=MergeTree() order by(ftable_name); ";
    }

    public static class CreateTableOption {
        private final boolean withIndex;
        private final boolean withPK;
        private final boolean withMemoryEngine;
        private final int bigStringLength;
        private final int pkStringLength;
        private final boolean useDBCharset;
        private final String tableCharset;
        private final String tableCollate;

        public CreateTableOption() {
            this.withIndex = PKTempTableConfig.isTempWithIndex();
            this.withPK = PKTempTableConfig.isTableCreateWithPk();
            this.withMemoryEngine = PKTempTableConfig.isMysqlUseMemoryEngine();
            this.bigStringLength = PKTempTableConfig.getBigStringLength();
            this.useDBCharset = PKTempTableConfig.isMysqlUseDbDefaultCharset();
            this.tableCharset = PKTempTableConfig.getMysqlTableCharset();
            this.tableCollate = PKTempTableConfig.getMysqlTableCollate();
            this.pkStringLength = PKTempTableConfig.getPkStringLength();
        }

        public CreateTableOption(boolean withIndex, boolean withPK, boolean withMemoryEngine, int bigStringLength, boolean useDBCharset, String tableCharset, String tableCollate, int pkStringLength) {
            this.withIndex = withIndex;
            this.withPK = withPK;
            this.withMemoryEngine = withMemoryEngine;
            this.bigStringLength = bigStringLength;
            this.useDBCharset = useDBCharset;
            this.tableCharset = tableCharset;
            this.tableCollate = tableCollate;
            this.pkStringLength = pkStringLength;
        }
    }
}

