/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table.ddl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.table.ddl.KsqlDDLSqlProvider;
import kd.bos.xdb.hint.NoShardingHint;

public class VastbaseDDLSqlProvider
extends KsqlDDLSqlProvider {
    private static final String CREATE_UNLOGGED_TABLE_SQL = "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)"CREATE UNLOGGED TABLE %s(FID %s, FVERSION INT NOT NULL)");
    private static final String CREATE_UNLOGGED_TABLE_WITH_PK_SQL = "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)"CREATE UNLOGGED TABLE %s(FID %s, FPKID BIGINT NOT NULL, FVERSION INT NOT NULL)");
    private static final String CREATE_TABLE_SQL = NoShardingHint.genNoShardingSQL((String)"CREATE TABLE %s(FID %s, FVERSION INT NOT NULL)");
    private static final String CREATE_TABLE_WITH_PK_SQL = NoShardingHint.genNoShardingSQL((String)"CREATE TABLE %s(FID %s, FPKID BIGINT NOT NULL, FVERSION INT NOT NULL)");
    private static final String CREATE_TABLE_PK_INDEX_SQL = NoShardingHint.genNoShardingSQL((String)"EXEC P_ALTERPK 'PK_%s', '%s', 'FPKID', '1'");
    private static final String CREATE_IDX_SQL = NoShardingHint.genNoShardingSQL((String)"IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_%s') CREATE INDEX IDX_%s ON %s(%s)");

    @Override
    public List<String> getCreateTempTableSql(InnerPKTempTable table, boolean withIndex, boolean withPk, int bigStringLength, int pkStringLength) {
        ArrayList<String> sqlList = new ArrayList<String>(4);
        String tableName = table.getName();
        if (PKTempTableConfig.isPgUseUnloggedTable()) {
            if (withPk) {
                sqlList.add(String.format(CREATE_UNLOGGED_TABLE_WITH_PK_SQL, tableName, this.getFidTypeString(table.getType(), bigStringLength, pkStringLength)));
                sqlList.add(String.format(CREATE_TABLE_PK_INDEX_SQL, tableName, tableName));
            } else {
                sqlList.add(String.format(CREATE_UNLOGGED_TABLE_SQL, tableName, this.getFidTypeString(table.getType(), bigStringLength, pkStringLength)));
            }
        } else if (withPk) {
            sqlList.add(String.format(CREATE_TABLE_WITH_PK_SQL, tableName, this.getFidTypeString(table.getType(), bigStringLength, pkStringLength)));
            sqlList.add(String.format(CREATE_TABLE_PK_INDEX_SQL, tableName, tableName));
        } else {
            sqlList.add(String.format(CREATE_TABLE_SQL, tableName, this.getFidTypeString(table.getType(), bigStringLength, pkStringLength)));
        }
        if (withIndex) {
            sqlList.add(this.getCreateIndexSql(tableName, "FID"));
        }
        sqlList.add(this.getCreateIndexSql(tableName, "FVERSION"));
        return sqlList;
    }

    private String getCreateIndexSql(String tableName, String fieldName) {
        return String.format(CREATE_IDX_SQL, tableName + '_' + fieldName, tableName + '_' + fieldName, tableName, fieldName);
    }
}

