/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.utils;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.xdb.hint.NoShardingHint;

public final class DBFeaturesUtils {
    private static final ConcurrentHashMap<String, Features> FEATURE_STORE = new ConcurrentHashMap(64);

    private DBFeaturesUtils() {
    }

    public static boolean supportedLoadDataInfile(DBRoute route) {
        Features features = FEATURE_STORE.computeIfAbsent(DBFeaturesUtils.getKey(route), key -> new Features(route));
        return features.getSupportedLoadDataInfile();
    }

    private static String getKey(DBRoute route) {
        RequestContextInfo rc = RequestContextInfo.get();
        return rc.getTenantId() + '#' + rc.getAccountId() + '#' + route.getRouteKey();
    }

    static enum Value {
        NULL,
        SUPPORTED,
        NOT_SUPPORTED;

    }

    static class Features {
        private final DBRoute route;
        private Value supportedLoadDataInfile = Value.NULL;

        public Features(DBRoute route) {
            this.route = route;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getSupportedLoadDataInfile() {
            if (this.supportedLoadDataInfile != Value.NULL) {
                return this.supportedLoadDataInfile == Value.SUPPORTED;
            }
            Features features = this;
            synchronized (features) {
                if (this.supportedLoadDataInfile != Value.NULL) {
                    return this.supportedLoadDataInfile == Value.SUPPORTED;
                }
                String sql = "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)"show variables like 'local_infile'");
                try (TXHandle ignored = TX.notSupported("check_db_supported_load_data_infile.");){
                    this.supportedLoadDataInfile = DB.query(this.route, sql, rs -> {
                        if (rs.next()) {
                            if (rs.getString(2).equalsIgnoreCase("ON")) {
                                return Value.SUPPORTED;
                            }
                            return Value.NOT_SUPPORTED;
                        }
                        return Value.NOT_SUPPORTED;
                    });
                }
                catch (Exception ignored2) {
                    this.supportedLoadDataInfile = Value.NOT_SUPPORTED;
                }
            }
            return this.supportedLoadDataInfile == Value.SUPPORTED;
        }
    }
}

