/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.utils;

import java.lang.reflect.Method;
import kd.bos.thread.SetThreadName;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ThreadLocals;

public final class PKTempTableThreadUtils {
    private static Method requestContextCreateMethod;
    private static Method setTraceIdMethod;
    private static Method bindRequestContextMethod;
    private static boolean reflectSuccess;

    private PKTempTableThreadUtils() {
    }

    public static void resetThread() {
        if (!reflectSuccess) {
            return;
        }
        try {
            ThreadLocals.release();
            SetThreadName.start();
            String traceId = TraceIdUtil.createTraceIdString();
            SetThreadName.setTraceId((String)traceId);
            Object rc = requestContextCreateMethod.invoke(null, new Object[0]);
            setTraceIdMethod.invoke(rc, traceId);
            bindRequestContextMethod.invoke(null, rc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        reflectSuccess = false;
        try {
            Class<?> rcClass = Class.forName("kd.bos.context.RequestContext");
            requestContextCreateMethod = rcClass.getDeclaredMethod("create", new Class[0]);
            setTraceIdMethod = rcClass.getMethod("setTraceId", String.class);
            bindRequestContextMethod = Class.forName("kd.bos.context.RequestContextThreadBinder").getDeclaredMethod("bind", rcClass);
            reflectSuccess = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

