/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.utils;

import kd.bos.db.DBType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;

public class TableVariableUtil {
    private TableVariableUtil() {
    }

    public static boolean isDMDbType(kd.bos.xdb.datasource.DBType dbType) {
        return dbType == kd.bos.xdb.datasource.DBType.dm && PKTempTableConfig.isDmEnableTableVariable();
    }

    public static boolean isDMDbType(DBType dbType) {
        return dbType == DBType.DM;
    }

    public static boolean allowUseTableVariable(kd.bos.xdb.datasource.DBType dbType) {
        if (dbType == kd.bos.xdb.datasource.DBType.oracle && PKTempTableConfig.isOracleEnableTableVariable() || dbType == kd.bos.xdb.datasource.DBType.dm && PKTempTableConfig.isDmEnableTableVariable()) {
            return true;
        }
        return TableVariableUtil.allowSetTableVariableParams(dbType);
    }

    public static boolean allowSetTableVariableParams(kd.bos.xdb.datasource.DBType dbType) {
        boolean enable = Boolean.parseBoolean(System.getProperty("db.table.variable.enable", "false"));
        if (!enable) {
            return false;
        }
        return dbType == kd.bos.xdb.datasource.DBType.postgresql || dbType == kd.bos.xdb.datasource.DBType.sqlserver;
    }

    public static boolean enableStringMaxSize(long size) {
        int limitSize = Integer.getInteger("db.table.variable.string.maxsize", 50000);
        return size < (long)limitSize;
    }

    public static boolean allowUseTableVariable(DBType dbType) {
        if (dbType == DBType.Oracle && PKTempTableConfig.isOracleEnableTableVariable() || dbType == DBType.DM && PKTempTableConfig.isDmEnableTableVariable()) {
            return true;
        }
        return TableVariableUtil.allowSetTableVariableParams(dbType);
    }

    public static boolean allowSetTableVariableParams(DBType dbType) {
        boolean enable = Boolean.parseBoolean(System.getProperty("db.table.variable.enable", "false"));
        if (!enable) {
            return false;
        }
        return dbType == DBType.PostgreSQL || dbType == DBType.SQLServer;
    }
}

