/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sharding;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.KSqlTransferImpl;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.govern.DBTimeoutHandler;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.db.sharding.TentantAccountShardingConfigProvider;
import kd.bos.db.sharding.TentantAccountShardingSQLCacheFactory;
import kd.bos.db.sharding.TentantAccountTableManagerFactory;
import kd.bos.db.sharding.configchanged.DBShardingConfigNotifier;
import kd.bos.db.sharding.tablecache.ChangeTableCacheNotifier;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockFactory;
import kd.bos.dlock.DLockType;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.cache.global.ShardingSQLCacheFactory;
import kd.bos.xdb.ext.KSQLTransfer;
import kd.bos.xdb.id.IDGenner;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.tablemanager.TableManagerFactory;
import kd.bos.xdb.util.Closeable;

final class ShardingManagerImpl
implements ShardingManager {
    protected static final ShardingManagerImpl INSTANCE = new ShardingManagerImpl();
    private static final Log log = LogFactory.getLog(ShardingManagerImpl.class);
    private TentantAccountShardingConfigProvider shardingConfigProvider;
    private TentantAccountShardingSQLCacheFactory shardingSQLCacheFactory;

    private ShardingManagerImpl() {
    }

    @Override
    public void setupXDB(int queryFetchSize) {
        XDBConfig xconfig = XDBConfig.get();
        ConfigurationUtil.observeBoolean((String)"xdb.enable", (boolean)false, v -> xconfig.setEnableSharding(v.booleanValue()));
        ConfigurationUtil.observeBoolean((String)"xdb.shardingSameGroupTable", (boolean)true, v -> xconfig.setShardingSameGroupTable(v.booleanValue()));
        ConfigurationUtil.observeBoolean((String)"xdb.devmode", (boolean)false, v -> xconfig.setDevMode(v.booleanValue()));
        ConfigurationUtil.observeBoolean((String)"xdb.pkseg", (boolean)false, v -> xconfig.setPkSeg(v.booleanValue()));
        ConfigurationUtil.observeInteger((String)"xdb.mod.max", (int)10000, v -> xconfig.setModMax(v.intValue()));
        ConfigurationUtil.observeBoolean((String)"xdb.log.sharding", (boolean)true, v -> xconfig.setEnableLogShardingSQL(v.booleanValue()));
        ConfigurationUtil.observeBoolean((String)"xdb.log.nosharding", (boolean)false, v -> xconfig.setEnableLogNoShardingSQL(v.booleanValue()));
        ConfigurationUtil.observeBoolean((String)"xdb.log.stat", (boolean)false, v -> xconfig.setEnableLogStat(v.booleanValue()));
        ConfigurationUtil.observeInteger((String)"xdb.single.parallel_query_size", (int)3, v -> xconfig.setSingleParallelSize(v.intValue()));
        ConfigurationUtil.observeBoolean((String)"xdb.forceParallelConn", (boolean)false, v -> xconfig.setForceParallelConn(v.booleanValue()));
        ConfigurationUtil.observeBoolean((String)"xdb.enableParallelExecute", (boolean)true, v -> xconfig.setEnableParallelExecute(v.booleanValue()));
        xconfig.setUseKSQL(true);
        xconfig.setKSqlTransfer((KSQLTransfer)KSqlTransferImpl.instance);
        xconfig.setQueryFetchSize(queryFetchSize);
        this.shardingConfigProvider = new TentantAccountShardingConfigProvider();
        this.shardingSQLCacheFactory = new TentantAccountShardingSQLCacheFactory();
        XDBConfig.setup((TableManagerFactory)new TentantAccountTableManagerFactory(), (ShardingSQLCacheFactory)this.shardingSQLCacheFactory, (ShardingConfigProvider)this.shardingConfigProvider, null, () -> new XDBExternal(){
            private TXHandle h;
            private List cls = null;

            public void close() {
                this.h.close();
                if (this.cls != null) {
                    for (Closeable c : this.cls) {
                        c.close();
                    }
                }
            }

            public void markRollback() {
                this.h.markRollback();
            }

            protected void doRequiresNew(String tag) {
                this.h = TX.requiresNew(tag);
            }

            protected void doNotSupported(String tag) {
                this.h = TX.notSupported(tag);
            }

            protected void addCloseableListener(Closeable c) {
                if (this.cls == null) {
                    this.cls = new ArrayList(2);
                }
                this.cls.add(c);
            }

            protected boolean doExecute(String dbRoute, String sql, Object[] params) {
                return DB.execute(DBRoute.of(dbRoute), sql, params);
            }

            protected void doQuery(String dbRoute, String sql, Object[] params, Consumer<ResultSet> rsConsumer) {
                DB.query(DBRoute.of(dbRoute), sql, params, rs -> {
                    rsConsumer.accept(rs);
                    return null;
                });
            }

            public boolean isUseTheSameDatabase(String ... dbRoutes) {
                return DB.isUseTheSameDatabase(dbRoutes);
            }
        });
        boolean isHaEnable = Boolean.parseBoolean(System.getProperty("ha.component.enable"));
        DLockType dlockType = isHaEnable ? DLockType.zookeeper : DLockType.valueOf((String)System.getProperty("xdb.dlock.type", DLockType.redis.name()));
        XDBConfig.setupDLock(key -> {
            DLock lock = DLockFactory.getDLockerManager((DLockType)dlockType).createLock(key, "xdb-sharding-manager", true);
            lock.lock();
            return () -> lock.unlock();
        });
        XDBConfig.setupIDGenner((IDGenner)new IDGenner(){

            public long id() {
                return ID.genLongId();
            }

            public Date getCreateTime(long id) {
                return ID.getCreateTime((long)id);
            }

            public Date getCreateTime(String id) {
                return ID.getCreateTime((String)id);
            }

            public String stringId36() {
                return ID.longTo36Radix((long)ID.genLongId());
            }

            public String stringId39() {
                return ID.genStringId();
            }
        });
        XDBConfig.setupXDBEnable(() -> DB.isXDBEnable());
        XDBConfig.setupGovernTimeout(() -> DBTimeoutHandler.handleGovRequestTimeout());
        DBShardingConfigNotifier.registReloadShardingConfigListener(si -> {
            log.info("[DBShardingConfigListener] onReceiveReloadShardingConfig " + si);
            DBShardingRuntime.getShardingConfigLoader().runWithDBAccessible(() -> this.reloadShardingConfig(si.getEntityName()), new RequestContextInfo(si.getTenantId(), si.getAccountId()));
        });
        ChangeTableCacheNotifier.registChangeTableCacheListener(ci -> {
            log.info("[ChangeTableCacheListener] onReceiveChangeTableCache " + ci);
            if (!ci.getInstanceId().equals(Instance.getInstanceId())) {
                try (AutoCloseable ac = new RequestContextInfo(ci.getTenantId(), ci.getAccountId()).setupThreadRequestContext();){
                    XDBConfig.getTableManager().add2Cahce(ci.getTableName());
                }
            }
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    public int loadShardingConfigs(boolean forceReload) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void notifyReloadShardingConfig(String entityName) {
        DBShardingConfigNotifier.fireReloadShardingConfig(entityName);
    }

    @Override
    public String notifyLimitTableRW(String tableName, boolean rw) {
        return DBShardingRuntime.get().fireLimitTableRW(tableName, rw);
    }

    @Override
    public void notifyLimitTaskPaused(boolean paused, String tableName) {
        ShardTaskRuntime.get().fireLimitTaskPaused(paused, tableName);
    }

    private void reloadShardingConfig(String entityName) {
        Set<ShardingConfig> configs = DBShardingRuntime.getShardingConfigLoader().load(entityName);
        if (configs != null && !configs.isEmpty()) {
            String mainTableName = null;
            for (ShardingConfig sc : configs) {
                if (!(sc instanceof MainTableConfig)) continue;
                mainTableName = sc.getTable();
                if (!sc.isEnabled()) break;
                this.shardingSQLCacheFactory.getShardingSQLCache().clear();
                break;
            }
            this.shardingConfigProvider.replaceConfigs(mainTableName, configs.toArray(new ShardingConfig[configs.size()]));
        } else {
            this.shardingConfigProvider.removeConfigs(DBShardingRuntime.getShardingConfigLoader().getEntityMainTable(entityName));
        }
    }
}

