/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sharding;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.sharding.TentantAccountAble;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.sharding.config.DefaultShardingConfigProvider;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigListener;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;

public class TentantAccountShardingConfigProvider
implements TentantAccountAble,
ShardingConfigProvider {
    private static final Log log = LogFactory.getLog((String)TentantAccountShardingConfigProvider.class.getSimpleName());
    private Map<String, ShardingConfigProvider> thMap = new ConcurrentHashMap<String, ShardingConfigProvider>();
    private ShardingConfigListener configInnerLogListener = new ShardingConfigListener(){

        public void onAdded(ShardingConfig ... scs) {
            log.info("Sharding config added(" + scs.length + "): " + Arrays.toString(scs));
        }

        public void onRemoved(ShardingConfig ... scs) {
            log.info("Sharding config removed(" + scs.length + "): " + Arrays.toString(scs));
        }
    };

    private ShardingConfigProvider get() {
        ShardingConfigProvider ret = this.thMap.get(this.getTentantAccountKey());
        if (ret != null) {
            return ret;
        }
        return this.thMap.computeIfAbsent(this.getTentantAccountKey(), key -> {
            DefaultShardingConfigProvider scp = new DefaultShardingConfigProvider();
            scp.addShardingConfigListener(this.configInnerLogListener);
            scp.setContextKey(this.getTentantAccountKey());
            return scp;
        });
    }

    public Set<ShardingConfig> getConfigs() {
        return this.get().getConfigs();
    }

    public ShardingConfig getConfig(String table) {
        return this.get().getConfig(table);
    }

    public MainTableConfig getMainConfig(String table) {
        return this.get().getMainConfig(table);
    }

    public List<ShardingConfig> getConfigs(String tableName) {
        return this.get().getConfigs(tableName);
    }

    public void addConfig(ShardingConfig sc) {
        this.get().addConfig(sc);
    }

    public void addConfigs(ShardingConfig ... scs) {
        this.get().addConfigs(scs);
    }

    public ShardingConfig removeConfig(String tableName) {
        return this.get().removeConfig(tableName);
    }

    public List<ShardingConfig> removeConfigs(String tableName) {
        return this.get().removeConfigs(tableName);
    }

    public void clearConfig() {
        this.get().clearConfig();
    }

    public void addShardingConfigListener(ShardingConfigListener scl) {
        this.get().addShardingConfigListener(scl);
    }

    public void removeShardingConfigListener(ShardingConfigListener scl) {
        this.get().removeShardingConfigListener(scl);
    }

    public void setContextKey(String contextKey) {
        this.get().setContextKey(contextKey);
    }

    public String getContextKey() {
        return this.get().getContextKey();
    }

    public boolean hasEnabledShardingConfig() {
        return this.get().hasEnabledShardingConfig();
    }

    public void replaceConfigs(String tableName, ShardingConfig ... scs) {
        this.get().replaceConfigs(tableName, scs);
    }

    public MainTableConfig getConfigByEntity(String entitynmber) {
        return this.get().getConfigByEntity(entitynmber);
    }
}

