/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sharding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.config.client.util.ConfigUtils;
import kd.bos.dlock.DLock;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.endpoint.EndPointValueChangeService;
import kd.bos.xdb.endpoint.EndPointValueNotifier;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;

public class ZKWatchValueNotifier {
    protected static final Log log = LogFactory.getLog(ZKWatchValueNotifier.class);
    private static final String ZK_URL;
    private static final String ZK_WATCHER_ROOT_PATH;
    protected static final long LOCK_TIMEOUT = 5000L;
    protected static final int RETRY_COUNT = 3;
    protected static boolean excludeZk;

    protected static void setZKWatchValue(String key, String value) {
        try {
            if (excludeZk) {
                EndPointValueChangeService.receiveValueChange((String)key, (String)value);
                EndPointValueNotifier.endPointFireChange((String)key, (String)value);
            } else {
                String fullPath = ZK_WATCHER_ROOT_PATH + key;
                CuratorFramework zkClient = ZKFactory.getZKClient((String)ZK_URL);
                if (zkClient.checkExists().forPath(fullPath) == null) {
                    zkClient.create().forPath(fullPath, value.getBytes());
                } else {
                    zkClient.setData().forPath(fullPath, value.getBytes());
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    protected static Set<String> getAllNodes() {
        try {
            HashSet<String> allNodes = new HashSet<String>();
            allNodes.addAll(ZKWatchValueNotifier.getAllInstanceIds());
            return allNodes;
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    private static List<String> getAllInstanceIds() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> eyeUtilsClazz = Class.forName("kd.bos.eye.service.EyeServerService");
        Method m = eyeUtilsClazz.getMethod("getAllInstanceNodes", new Class[0]);
        List instances = (List)m.invoke(eyeUtilsClazz, new Object[0]);
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireLimit(String lockKey, String watcherKey, String value) {
        boolean fired = false;
        DLock lock = DLock.create((String)lockKey);
        for (int i = 0; i < 3; ++i) {
            if (!lock.tryLock(5000L)) continue;
            try {
                ZKWatchValueNotifier.setZKWatchValue(watcherKey, value);
                fired = true;
                break;
            }
            finally {
                lock.unlock();
            }
        }
        if (!fired) {
            ZKWatchValueNotifier.setZKWatchValue(watcherKey, value);
        }
    }

    protected static void observeChange(String watcherKey, ConfigurationChangeListener listener) {
        if (excludeZk) {
            EndPointValueChangeService.observeChange((String)watcherKey, (ConfigurationChangeListener)listener);
        } else {
            ConfigurationUtil.observeChange((String)watcherKey, (ConfigurationChangeListener)listener);
        }
    }

    static {
        excludeZk = false;
        excludeZk = !"zookeeper".equalsIgnoreCase(ConfigUtils.getConfigUrlType()) || Boolean.getBoolean("xdb.exclude.zk");
        ZK_URL = System.getProperty("configUrl");
        ZK_WATCHER_ROOT_PATH = ConfigUtils.getCommonPropertyPath((String)Instance.getClusterName()) + "/";
    }
}

