/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.splittingread;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.DisCardUtil;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.ConcurrentHashSet;

public class SplittingReadConfig {
    private static Map<String, Set<String>> allowSplittingReadTableMap = new HashMap<String, Set<String>>();
    private static Set<String> turnOffAccountSet = new ConcurrentHashSet();
    private static boolean splittingReadEnable = true;
    private static boolean splittingAutoReadWrite = false;
    private static boolean splittingLogConnection = false;
    private static boolean logDebugInfo = false;
    private static Set<String> enableKeyWhiteSet = new ConcurrentHashSet();
    private static TempTableInReadWriteContextStrategy tempTableInReadWriteContextStrategy;

    public static void turnAccount(Account account) {
        String key = account.getTenantId() + "#" + account.getAccountId();
        if (account.isSplittingRead()) {
            turnOffAccountSet.remove(key);
        } else {
            turnOffAccountSet.add(key);
        }
    }

    private static Map<String, Set<String>> fromConfigString(String v, GetTables gt) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        if (v != null && v.length() > 0) {
            String[] ss;
            for (String s : ss = v.split(";")) {
                String accountId;
                int i = (s = s.trim()).indexOf(61);
                if (i == -1 || (accountId = s.substring(0, i).trim()).length() <= 0) continue;
                if (s.endsWith("=")) {
                    map.put(accountId, new HashSet());
                    continue;
                }
                String[] items = s.substring(i + 1).split(",");
                HashSet<String> set = new HashSet<String>(items.length);
                for (String name : items) {
                    for (String table : gt.tables(name.trim().toLowerCase())) {
                        set.add(table);
                    }
                }
                map.put(accountId, set);
            }
        }
        return map;
    }

    public static boolean allowSplittingRead(String accountId, String ... tables) {
        Set<String> set = allowSplittingReadTableMap.get(accountId);
        if (set != null) {
            if (set.contains("*")) {
                return true;
            }
            for (String table : tables) {
                if (set.contains(TableName.of((String)table).getOriginalName())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isSplittingReadEnable() {
        if (splittingReadEnable) {
            RequestContextInfo rc = RequestContextInfo.get();
            String key = rc.getTenantId() + "#" + rc.getAccountId();
            return !turnOffAccountSet.contains(key);
        }
        return false;
    }

    public static boolean isGlobalEnable() {
        return splittingReadEnable;
    }

    public static boolean isAccountEnable() {
        RequestContextInfo rc = RequestContextInfo.get();
        String key = rc.getTenantId() + "#" + rc.getAccountId();
        return !turnOffAccountSet.contains(key);
    }

    public static boolean isSplittingAutoReadWrite() {
        return splittingAutoReadWrite && SplittingReadConfig.isSplittingReadEnable();
    }

    @Deprecated
    public static boolean isSplittingLogConnection() {
        return splittingLogConnection && SplittingReadConfig.isSplittingReadEnable();
    }

    public static boolean isEnableReadWrite(String key) {
        if (key == null) {
            return false;
        }
        return enableKeyWhiteSet.contains(key.toLowerCase());
    }

    public static TempTableInReadWriteContextStrategy getTempTableInReadWriteContextStrategy() {
        return tempTableInReadWriteContextStrategy;
    }

    public static boolean isLogDebugInfo() {
        return logDebugInfo;
    }

    static {
        ConfigurationUtil.observeString((String)"db.splittingread.tables", (String)"", v -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        ConfigurationUtil.observeBoolean((String)"db.splittingread.enable", (boolean)splittingReadEnable, v -> {
            splittingReadEnable = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.splittingread.autoreadwrite", (boolean)splittingAutoReadWrite, v -> {
            splittingAutoReadWrite = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.splittingread.logconnection", (boolean)splittingLogConnection, v -> {
            splittingLogConnection = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.splittingread.logDebugInfo", (boolean)logDebugInfo, v -> {
            logDebugInfo = v;
        });
        ConfigurationUtil.observeString((String)"db.splittingread.whitelist", (String)"", v -> {
            String[] whiteList = v.split(",");
            ConcurrentHashSet set = new ConcurrentHashSet();
            for (String s : whiteList) {
                set.add((Object)s.trim().toLowerCase());
            }
            enableKeyWhiteSet = set;
        });
        ConfigurationUtil.observeString((String)"db.splittingread.temptablestrategy", (String)TempTableInReadWriteContextStrategy.WRITE_FORCE.getValue(), v -> {
            tempTableInReadWriteContextStrategy = TempTableInReadWriteContextStrategy.READ_FORCE.getValue().equalsIgnoreCase((String)v) ? TempTableInReadWriteContextStrategy.READ_FORCE : TempTableInReadWriteContextStrategy.WRITE_FORCE;
        });
        TenantListenerManager.addTenantListener(new TenantListener(){

            @Override
            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                DisCardUtil.discard();
            }

            @Override
            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                DisCardUtil.discard();
            }

            @Override
            public void onTenantChanged(TenantListenerInfo tenantListenerInfo) {
                for (Account account : tenantListenerInfo.getAccountList()) {
                    SplittingReadConfig.turnAccount(account);
                }
            }
        });
    }

    static enum TempTableInReadWriteContextStrategy {
        WRITE_FORCE("write_force"),
        READ_FORCE("read_force");

        private String value;

        private TempTableInReadWriteContextStrategy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @FunctionalInterface
    private static interface GetTables {
        public String[] tables(String var1);
    }
}

