/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.splittingread;

import kd.bos.db.DB;
import kd.bos.db.splittingread.SplittingReadConfig;
import kd.bos.db.splittingread.SplittingReadWriteMode;
import kd.bos.util.ThreadLocals;
import kd.sdk.annotation.SdkInternal;

public class ThreadReadWriteContext
implements AutoCloseable {
    private static final ThreadLocal<ThreadReadWriteContext> thCtx = ThreadLocals.create();
    private final ThreadReadWriteContext parent;
    private SplittingReadWriteMode mode;

    @Deprecated
    @SdkInternal
    public static ThreadReadWriteContext createRead() {
        return new ThreadReadWriteContext(SplittingReadWriteMode.read, thCtx.get());
    }

    public static ThreadReadWriteContext createWrite() {
        return new ThreadReadWriteContext(SplittingReadWriteMode.write, thCtx.get());
    }

    @Deprecated
    @SdkInternal
    public static ThreadReadWriteContext createAutoReadWrite() {
        return new ThreadReadWriteContext(SplittingReadWriteMode.auto, thCtx.get());
    }

    public static ThreadReadWriteContext createRead(String key) {
        if (!SplittingReadConfig.isEnableReadWrite(key)) {
            return ThreadReadWriteContext.createWrite();
        }
        return new ThreadReadWriteContext(SplittingReadWriteMode.read, thCtx.get());
    }

    public static ThreadReadWriteContext createAutoReadWrite(String key) {
        if (!SplittingReadConfig.isEnableReadWrite(key)) {
            return ThreadReadWriteContext.createWrite();
        }
        return new ThreadReadWriteContext(SplittingReadWriteMode.auto, thCtx.get());
    }

    public static boolean isAllowUseTempTable() {
        SplittingReadWriteMode mode = ThreadReadWriteContext.getCurrentSplittingReadWriteMode();
        if (mode == SplittingReadWriteMode.write) {
            return true;
        }
        return SplittingReadConfig.getTempTableInReadWriteContextStrategy() == SplittingReadConfig.TempTableInReadWriteContextStrategy.WRITE_FORCE;
    }

    public static void forceSetWriteMode() {
        ThreadReadWriteContext context = ThreadReadWriteContext.get();
        if (context != null && context.getMode() != SplittingReadWriteMode.write) {
            context.mode = SplittingReadWriteMode.write;
        }
    }

    public static SplittingReadWriteMode getCurrentSplittingReadWriteMode() {
        ThreadReadWriteContext ctx;
        if (DB.isSplittingReadEnable() && (ctx = thCtx.get()) != null) {
            return ctx.getMode();
        }
        return SplittingReadWriteMode.write;
    }

    public static ThreadReadWriteContext get() {
        return thCtx.get();
    }

    private ThreadReadWriteContext(SplittingReadWriteMode mode, ThreadReadWriteContext parent) {
        this.mode = mode;
        this.parent = parent;
        thCtx.set(this);
    }

    public SplittingReadWriteMode getMode() {
        return this.mode;
    }

    @Override
    public void close() {
        thCtx.set(this.parent);
    }
}

