/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sql.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.KSQLTop;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.JdbcConstants;
import java.util.List;
import kd.bos.xdb.ext.KSQL;

public class TXImplicitDecisionVisitor
extends MySqlASTVisitorAdapter {
    private boolean implicit = true;
    private long selectFieldCount;
    private long topCount;
    private boolean visitOnce = true;

    public TXImplicitDecisionVisitor(long selectFieldCount, long topCount) {
        this.selectFieldCount = selectFieldCount;
        this.topCount = topCount;
    }

    public static boolean needEnableImplicit(String sql, long selectFieldCount, long topCount) {
        if (KSQL.isDialect((String)sql)) {
            return false;
        }
        SQLStatement sqlStatement = (SQLStatement)SQLUtils.parseStatements((String)sql, (DbType)JdbcConstants.MYSQL).get(0);
        if (sqlStatement instanceof SQLSelectStatement) {
            TXImplicitDecisionVisitor implicitAdjustmentVisitor = new TXImplicitDecisionVisitor(selectFieldCount, topCount);
            sqlStatement.accept((SQLASTVisitor)implicitAdjustmentVisitor);
            return implicitAdjustmentVisitor.isImplicit();
        }
        return false;
    }

    public boolean visit(MySqlSelectQueryBlock x) {
        if (this.visitOnce) {
            this.visitOnce = false;
            KSQLTop top = x.getKsqlTop();
            if (top != null) {
                Number number;
                SQLExpr rowCount = top.getRowCount();
                if (rowCount instanceof SQLIntegerExpr && ((number = ((SQLIntegerExpr)rowCount).getNumber()) instanceof Long && number.longValue() <= this.topCount || number instanceof Integer && (long)number.intValue() <= this.topCount || number.longValue() <= this.topCount)) {
                    this.implicit = false;
                }
                return true;
            }
            List selectList = x.getSelectList();
            for (SQLSelectItem selectItem : selectList) {
                SQLAggregateExpr sqlAggregateExpr;
                String methodName;
                SQLExpr selectItemExpr = selectItem.getExpr();
                if (!(selectItemExpr instanceof SQLAggregateExpr) || !"count".equalsIgnoreCase(methodName = (sqlAggregateExpr = (SQLAggregateExpr)selectItemExpr).getMethodName()) && !"sum".equalsIgnoreCase(methodName) && !"avg".equalsIgnoreCase(methodName) && !"min".equalsIgnoreCase(methodName) && !"max".equalsIgnoreCase(methodName)) continue;
                this.implicit = false;
                break;
            }
        }
        return true;
    }

    public boolean isImplicit() {
        return this.implicit;
    }
}

